package viewer.graph.rna;

import rnadesign.rnamodel.Atom3D;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.MeshOperations;
import tools3d.Vector4D;

/**
 * Translate the sphere mesh generated by
 * the SphericalAtomRendererGraph to the position
 * of the atom in 3D space.
 * @author Calvin
 *
 */
public class TranslatedSphericalAtomRenderer extends SphericalAtomRendererGraph {

	public TranslatedSphericalAtomRenderer(Atom3D atom) {
		super(atom);
	}

	@Override
	public AdvancedMesh generateMesh() {
		AdvancedMesh mesh = super.generateMesh();
		Vector4D position = new Vector4D(getAtom().getPosition());
		position.setW(1.0);
		return (AdvancedMesh) MeshOperations.translateMesh(mesh, position);
	}
	
	public String getClassName() {
		return "TranslatedSphericalAtomRenderer";
	}
	

}
