package rnasecondary;

import java.util.*;

import java.util.logging.Logger;
import sequence.*;

// import static rnadesign.rnamodel.PackageConstants.*;
import static rnasecondary.PackageConstants.*;

/** Output of secondary structure as single-strand "CT" format (as generated by mfold and other programs) */
public class SecondaryStructureFastaFormatWriter implements SecondaryStructureWriter {


    public static final String NEWLINE = System.getProperty("line.separator");

    /** generates array of integers as if all sequences were concatenated to one sequence */
    public String writeString(SecondaryStructure structure) {
	StringBuffer buf = new StringBuffer();
	for (int i = 0; i < structure.getSequenceCount(); ++i) {
	    buf.append(">" + structure.getSequence(i).getName() + NEWLINE);
	    buf.append(structure.getSequence(i).sequenceString());
	    if ((i+1) < structure.getSequenceCount()) {
		buf.append(NEWLINE);
	    }
	}
	return buf.toString();
    }

}
