package rnasecondary;

import java.util.*;

/**  Implements concept of several target structures that a set of sequences can have */
public class SecondaryMultiStructure {

    private ArrayList<String> sequences;
    private ArrayList<SecondaryStructure> structures;
    private ArrayList<ArrayList<Integer> > sequenceIds;

    public SecondaryMultiStructure(List<String> _sequences,
				   List<SecondaryStructure> _structures,
				   List<List<Integer> > _sequenceIds) {
	sequences = new ArrayList<String>();
	structures = new ArrayList<SecondaryStructure>();
	sequenceIds = new ArrayList<ArrayList<Integer> >();
	sequences.addAll(_sequences);
	structures.addAll(_structures);
	assert(structures.size() == _structures.size());
	for (int i = 0; i < _sequenceIds.size(); ++i) {
	    // sequenceIds.get(i).get(j) stores to which original sequence sequence j of structure i belongs
	    assert(_sequenceIds.get(i).size() == structures.get(i).getSequenceCount());
	    sequenceIds.get(i).addAll(_sequenceIds.get(i));
	}
    }
	
    
    SecondaryStructure getSecondaryStructure(int n) { return structures.get(n); }

}
