package rnadesign.rnacontrol;

import java.util.*;
import tools3d.objects3d.*;
import tools3d.symmetry2.*;

/** "Controller" class for generating scripts the execute a complex series of commands */
public class ScriptController {
    
    public static String generateGraphTraceScript(Object3D graphRoot, LinkSet links, String name,
						  List<SymEdgeConstraint> symConstraints, Properties params,
						  String algorithm, boolean kissingLoopMode) throws Object3DGraphControllerException {
	// Object3DSet vertices, 
	// ScriptGenerator generator = new TraceGraphScriptGenerator(vertices, links, name, symConstraints, params);
	ScriptGenerator generator = null;
	if ("helix".equals(algorithm)) {
	    generator = new TraceGraphScriptGenerator2(graphRoot, links, name, symConstraints, params);
	} else if ("db".equals(algorithm)) {
	    generator = new TraceGraphDBScriptGenerator(graphRoot, links, name, symConstraints, params, kissingLoopMode);
	} else {
	    throw new Object3DGraphControllerException("Unknown trance script generator algorithm: " + algorithm + " . Defined are: helix|db");
	}
	assert generator != null;
	return generator.generate();
    }
    
}
