package rnadesign.designapp.rnagui;

import tools3d.GeometryColorModel;

/** creates all the shape painters of the NanoTiler factory */
public class NanoTilerGeometryPainterFactory implements GeometryPainterFactory {

    public static final int STANDARD_PAINTER = 2;

    public static final int SOLID_PAINTER = 2;

    public static final int WIRE_PAINTER = 3;

    public static final int WIREFRAME_PAINTER = 4;

    public static final int WIRE_CHARACTER_PAINTER = 5;

    public static final int NO_LINK_PAINTER = 6;

    public static final int RAINBOW_PAINTER = 7;

    public static final int RNASTRAND_PAINTER = 8;

    /** returns class WireGeometryPainter */
    public AbstractGeometryPainter createWirePainter() {
	return new WireGeometryPainter();
    }

    /** returns class SolidGeometryPainter */
    public AbstractGeometryPainter createSolidPainter() {
	return new SolidGeometryPainter();
    }

    /** returns class WireFrameGeometryPainter */
    public AbstractGeometryPainter createWireFramePainter() {
	return new WireFrameGeometryPainter();
    }

    /** returns class WireCharacterPainter */
    public AbstractPainter createWireCharacterPainter() {
	return new WireGeometryCharactersPainter();
    }

    /** returns class NoLinkGeometryPainter */
    public AbstractGeometryPainter createNoLinkPainter() {
	return new NoLinkGeometryPainter();
    }

    public GeometryColorModel createRainbowPainter() {
  	return new RainbowColorModel();
    }
    
    public GeometryColorModel createRnaStrandPainter() {
 	return new RnaStrandColorModel();
    }

    /** returns default painter */
    public GeometryPainter createPainter() {
	return createPainter(STANDARD_PAINTER);
    }

    public GeometryPainter createPainter(int styleId) {
	return createPainter(styleId, true);

    }

    /** creates painter */
    public GeometryPainter createPainter(int styleId, boolean paintLinks) {
	AbstractGeometryPainter shapePainter = null;
 	GeometryColorModel colorModel = null;
	switch (styleId) {
	case SOLID_PAINTER:
	    shapePainter = createSolidPainter();
	    break;
	case WIRE_CHARACTER_PAINTER:
	case WIRE_PAINTER:
	    shapePainter = createWirePainter();
	    break;
        case WIREFRAME_PAINTER:
	    shapePainter = createWireFramePainter();
	    break;
	    //case WIRE_CHARACTER_PAINTER:
	    //shapePainter = createWireCharacterPainter();
	    //break;
	    //case NO_LINK_PAINTER:
	    //   shapePainter = createNoLinkPainter();
	    //  break;
	    //case RAINBOW_PAINTER:
	    //    colorModel = createRainbowPainter();
	    //    break;
	    //case RNASTRAND_PAINTER:
	    //   colorModel = createRnaStrandPainter();
	    //   break;
	default:
	    // TODO error!
	    // shapePainter = createPainter();
	}
	shapePainter.setPaintLinks(paintLinks);
	return shapePainter;
    }
}
