/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry.spline;

import no.geosoft.cc.geometry.spline.CubicSpline;

class CatmullRomSpline
extends CubicSpline {
    CatmullRomSpline(double[] dArray, int n) {
        super(dArray, n);
    }

    protected void initialize(double[] dArray, int n) {
        this.nParts_ = n;
        this.controlPoints_ = new double[dArray.length + 6];
        System.arraycopy(dArray, 0, this.controlPoints_, 3, dArray.length);
        this.controlPoints_[0] = this.controlPoints_[3];
        this.controlPoints_[1] = this.controlPoints_[4];
        this.controlPoints_[2] = this.controlPoints_[5];
        this.controlPoints_[this.controlPoints_.length - 3] = this.controlPoints_[this.controlPoints_.length - 6];
        this.controlPoints_[this.controlPoints_.length - 2] = this.controlPoints_[this.controlPoints_.length - 5];
        this.controlPoints_[this.controlPoints_.length - 1] = this.controlPoints_[this.controlPoints_.length - 4];
    }

    protected double blend(int n, double d) {
        if (n == -2) {
            return ((-d + 2.0) * d - 1.0) * d / 2.0;
        }
        if (n == -1) {
            return ((3.0 * d - 5.0) * d * d + 2.0) / 2.0;
        }
        if (n == 0) {
            return ((-3.0 * d + 4.0) * d + 1.0) * d / 2.0;
        }
        return (d - 1.0) * d * d / 2.0;
    }
}

