/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestNGCommandLineArgs {
    public static final String SHOW_TESTNG_STACK_FRAMES = "testng.show.stack.frames";
    public static final String TEST_CLASSPATH = "testng.test.classpath";
    public static final String OUTDIR_COMMAND_OPT = "-d";
    public static final String TESTCLASS_COMMAND_OPT = "-testclass";
    public static final String TESTJAR_COMMAND_OPT = "-testjar";
    public static final String SRC_COMMAND_OPT = "-sourcedir";
    public static final String PORT_COMMAND_OPT = "-port";
    public static final String HOST_COMMAND_OPT = "-host";
    public static final String LOG = "-log";
    public static final String TARGET_COMMAND_OPT = "-target";
    public static final String GROUPS_COMMAND_OPT = "-groups";
    public static final String EXCLUDED_GROUPS_COMMAND_OPT = "-excludegroups";
    public static final String TESTRUNNER_FACTORY_COMMAND_OPT = "-testrunfactory";
    public static final String LISTENER_COMMAND_OPT = "-listener";
    public static final String SUITE_DEF_OPT = "testng.suite.definitions";
    public static final String JUNIT_DEF_OPT = "-junit";
    public static final String SLAVE_OPT = "-slave";
    public static final String HOSTFILE_OPT = "-hostfile";
    public static final String THREAD_COUNT = "-threadcount";
    public static final String USE_DEFAULT_LISTENERS = "-usedefaultlisteners";
    private static int m_lastGoodRootIndex = -1;

    private TestNGCommandLineArgs() {
    }

    public static Map parseCommandLine(String[] originalArgv) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        String[] argv = TestNGCommandLineArgs.expandArgv(originalArgv);
        for (int i = 0; i < argv.length; ++i) {
            if (OUTDIR_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(OUTDIR_COMMAND_OPT, argv[i + 1].trim());
                } else {
                    System.err.println("WARNING: missing output directory after -d.  ignored");
                }
                ++i;
                continue;
            }
            if (GROUPS_COMMAND_OPT.equalsIgnoreCase(argv[i]) || EXCLUDED_GROUPS_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    String option = null;
                    if (argv[i + 1].startsWith("\"")) {
                        if (argv[i + 1].endsWith("\"")) {
                            option = argv[i + 1].substring(1, argv[i + 1].length() - 1);
                        } else {
                            System.err.println("WARNING: groups option is not well quoted:" + argv[i + 1]);
                            option = argv[i + 1].substring(1);
                        }
                    } else {
                        option = argv[i + 1];
                    }
                    String opt = GROUPS_COMMAND_OPT.equalsIgnoreCase(argv[i]) ? GROUPS_COMMAND_OPT : EXCLUDED_GROUPS_COMMAND_OPT;
                    arguments.put(opt, option);
                } else {
                    System.err.println("WARNING: missing groups parameter after -groups. ignored");
                }
                ++i;
                continue;
            }
            if (LOG.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(LOG, Integer.valueOf(argv[i + 1].trim()));
                } else {
                    System.err.println("WARNING: missing log level after -log.  ignored");
                }
                ++i;
                continue;
            }
            if (JUNIT_DEF_OPT.equalsIgnoreCase(argv[i])) {
                arguments.put(JUNIT_DEF_OPT, Boolean.TRUE);
                continue;
            }
            if (TARGET_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                if ("1.4".equals(argv[i + 1]) || "1.5".equals(argv[i + 1])) {
                    arguments.put(TARGET_COMMAND_OPT, argv[i + 1]);
                } else {
                    System.err.println("WARNING: missing/invalid target argument. Must be 1.4 or 1.5. Ignoring");
                }
                ++i;
                continue;
            }
            if (TESTRUNNER_FACTORY_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(TESTRUNNER_FACTORY_COMMAND_OPT, TestNGCommandLineArgs.fileToClass(argv[++i]));
                    continue;
                }
                System.err.println("WARNING: missing ITestRunnerFactory class or file argument after -testrunfactory");
                continue;
            }
            if (LISTENER_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    String[] strs = Utils.split(argv[++i], ";");
                    ArrayList<Class> classes = new ArrayList<Class>();
                    for (String cls : strs) {
                        classes.add(TestNGCommandLineArgs.fileToClass(cls));
                    }
                    arguments.put(LISTENER_COMMAND_OPT, classes);
                    continue;
                }
                System.err.println("WARNING: missing ITestListener class/file list argument after -listener");
                continue;
            }
            if (TESTCLASS_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    String nextArg;
                    while (i + 1 < argv.length && !(nextArg = argv[i + 1].trim()).toLowerCase().endsWith(".xml") && !nextArg.startsWith("-")) {
                        Class cls;
                        ArrayList<Class> l = (ArrayList<Class>)arguments.get(TESTCLASS_COMMAND_OPT);
                        if (null == l) {
                            l = new ArrayList<Class>();
                            arguments.put(TESTCLASS_COMMAND_OPT, l);
                        }
                        if (null != (cls = TestNGCommandLineArgs.fileToClass(nextArg))) {
                            l.add(cls);
                        }
                        ++i;
                    }
                    continue;
                }
                TestNG.exitWithError("-testclass must be followed by a classname");
                continue;
            }
            if (TESTJAR_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(TESTJAR_COMMAND_OPT, argv[i + 1].trim());
                } else {
                    TestNG.exitWithError("-testjar must be followed by a valid jar");
                }
                ++i;
                continue;
            }
            if (SRC_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(SRC_COMMAND_OPT, argv[i + 1].trim());
                } else {
                    TestNG.exitWithError("-sourcedir must be followed by a directory path");
                }
                ++i;
                continue;
            }
            if (HOST_COMMAND_OPT.equals(argv[i])) {
                String hostAddress = "127.0.0.1";
                if (i + 1 < argv.length) {
                    hostAddress = argv[i + 1].trim();
                    ++i;
                } else {
                    System.out.println("WARNING: -host option should be followed by the host address. Using default localhost.");
                }
                arguments.put(HOST_COMMAND_OPT, hostAddress);
                continue;
            }
            if (PORT_COMMAND_OPT.equals(argv[i])) {
                String portNumber = null;
                if (i + 1 < argv.length) {
                    portNumber = argv[i + 1].trim();
                } else {
                    TestNG.exitWithError("-port option should be followed by a valid port number.");
                }
                arguments.put(PORT_COMMAND_OPT, portNumber);
                ++i;
                continue;
            }
            if (SLAVE_OPT.equals(argv[i])) {
                String clientPortNumber = null;
                if (i + 1 < argv.length) {
                    clientPortNumber = argv[i + 1].trim();
                } else {
                    TestNG.exitWithError("-slave option should be followed by a valid port number.");
                }
                arguments.put(SLAVE_OPT, clientPortNumber);
                ++i;
                continue;
            }
            if (HOSTFILE_OPT.equals(argv[i])) {
                String hostFile = null;
                if (i + 1 < argv.length) {
                    hostFile = argv[i + 1].trim();
                } else {
                    TestNG.exitWithError("-hostfile option should be followed by the name of a file.");
                }
                arguments.put(HOSTFILE_OPT, hostFile);
                ++i;
                continue;
            }
            if (THREAD_COUNT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(THREAD_COUNT, argv[i + 1]);
                ++i;
                continue;
            }
            if (USE_DEFAULT_LISTENERS.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(USE_DEFAULT_LISTENERS, argv[i + 1]);
                ++i;
                continue;
            }
            if (argv[i].startsWith("-")) {
                TestNG.exitWithError("Unknown option: " + argv[i]);
                continue;
            }
            ArrayList<String> suiteDefs = new ArrayList<String>();
            for (int k = i; k < argv.length; ++k) {
                String file = argv[k].trim();
                if (!file.toLowerCase().endsWith(".xml")) continue;
                suiteDefs.add(file);
                ++i;
            }
            arguments.put(SUITE_DEF_OPT, suiteDefs);
        }
        return arguments;
    }

    private static String[] expandArgv(String[] originalArgv) {
        ArrayList<String> vResult = new ArrayList<String>();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                List<String> lines = TestNGCommandLineArgs.readFile(fileName);
                for (String line : lines) {
                    List<String> args = TestNGCommandLineArgs.parseArgs(line);
                    for (String oneArg : args) {
                        vResult.add(oneArg);
                    }
                }
                continue;
            }
            vResult.add(arg);
        }
        return vResult.toArray(new String[vResult.size()]);
    }

    private static List<String> parseArgs(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(line);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static List<String> readFile(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            FileReader input = new FileReader(fileName);
            BufferedReader bufRead = new BufferedReader(input);
            String line = bufRead.readLine();
            while (line != null) {
                result.add(line);
                line = bufRead.readLine();
            }
            bufRead.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Class fileToClass(String file) {
        int i;
        String className;
        Class result = null;
        int classIndex = file.indexOf(".class");
        if (-1 == classIndex && -1 == (classIndex = file.indexOf(".java"))) {
            result = ClassHelper.forName(file);
            if (null == result) {
                throw new TestNGException("Cannot load class from file: " + file);
            }
            return result;
        }
        String shortFileName = file.substring(0, classIndex);
        String[] segments = shortFileName.split("[/\\\\]", -1);
        if (-1 != m_lastGoodRootIndex) {
            className = segments[m_lastGoodRootIndex];
            for (i = m_lastGoodRootIndex + 1; i < segments.length; ++i) {
                className = className + "." + segments[i];
            }
            result = ClassHelper.forName(className);
            if (null != result) {
                return result;
            }
        }
        className = null;
        for (i = segments.length - 1; i >= 0; --i) {
            result = ClassHelper.forName(className = null == className ? segments[i] : segments[i] + "." + className);
            if (null == result) continue;
            m_lastGoodRootIndex = i;
            break;
        }
        if (null == result) {
            throw new TestNGException("Cannot load class from file: " + file);
        }
        return result;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("[-d output-directory]");
        System.out.println("\t\tdefault output directory to : test-output");
        System.out.println("[-testclass list of .class files or list of class names]");
        System.out.println("[-sourcedir a source directory]");
        System.out.println("[-target 1.4 or 1.5]");
        System.out.println("\t\tused only with JDK1.5 to specify the annotation type used in test classes; default target: 1.5");
        System.out.println("[-groups comma-separated list of group names to be run]");
        System.out.println("\t\tworks only with -testclass");
        System.out.println("[-excludegroups comma-separated list of group names to be excluded]");
        System.out.println("\t\tworks only with -testclass");
        System.out.println("[-testrunfactory list of .class files or list of class names implementing " + ITestRunnerFactory.class.getName() + "]");
        System.out.println("[-listener list of .class files or list of class names implementing " + ITestListener.class.getName() + " and/or " + ISuiteListener.class.getName() + "]");
        System.out.println("[-threadcount number of threads to use]");
        System.out.println("[suite definition files*]");
        System.out.println("");
        System.out.println("For details please consult documentation.");
    }
}

