/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.graphics.Material;
import viewer.rnadesign.RNAColorModel;
import viewer.util.Pair;

public class RainbowColorModel
extends RNAColorModel {
    private static final Color[][] COLOR_PAIRS = new Color[][]{{Color.red, Color.orange}, {Color.orange, Color.yellow}, {Color.yellow, Color.green}, {Color.green, Color.blue}};
    private int pairIndexer = 0;
    private Map<Object3D, Material> nMap = new HashMap<Object3D, Material>();
    private Map<Object3D, Pair<Color, Color>> sMap = new HashMap<Object3D, Pair<Color, Color>>();

    @Override
    public Material getDefaultMaterial() {
        Material m = super.getDefaultMaterial();
        m.getAmbient().setAlpha(1.0);
        return m;
    }

    @Override
    public Material getMaterial(Link link) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getAtomMaterial(Atom3D atom) {
        Nucleotide3D n = this.getNucleotide(atom);
        if (n == null) {
            return this.getDefaultMaterial();
        }
        return this.getNucleotideMaterial(n);
    }

    @Override
    public Material getBranchDescriptorMaterial(BranchDescriptor3D b) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getKissingLoopMaterial(KissingLoop3D k) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getNucleotideMaterial(Nucleotide3D n) {
        Color color1;
        System.out.println("Rainbow Color Model getNucleotideMaterial() called");
        if (this.nMap.containsKey(n)) {
            return this.nMap.get(n);
        }
        if (!(n.getParent() instanceof RnaStrand)) {
            return this.getDefaultMaterial();
        }
        RnaStrand s = (RnaStrand)n.getParent();
        if (this.sMap.containsKey(s)) {
            Pair<Color, Color> p = this.sMap.get(s);
            color1 = p.getFirst();
            Color color = p.getSecond();
        }
        int size = s.size();
        int index = s.getIndexOfChild(n);
        double ratio = (double)index / (double)size;
        for (int section = 1; section <= COLOR_PAIRS.length; ++section) {
            double sectionStart = (double)(section - 1) / (double)COLOR_PAIRS.length;
            double sectionEnd = (double)section / (double)COLOR_PAIRS.length;
            if (!(ratio >= sectionStart) || !(ratio <= sectionEnd)) continue;
            color1 = COLOR_PAIRS[section - 1][0];
            Color color2 = COLOR_PAIRS[section - 1][1];
            int rRange = color2.getRed() - color1.getRed();
            int bRange = color2.getBlue() - color1.getBlue();
            int gRange = color2.getGreen() - color1.getGreen();
            double sectionRatio = (ratio - sectionStart) / (sectionEnd - sectionStart);
            Color c = new Color(color1.getRed() + (int)(sectionRatio * (double)rRange), color1.getGreen() + (int)(sectionRatio * (double)gRange), color1.getBlue() + (int)(sectionRatio * (double)bRange));
            Material m = new Material(c);
            this.nMap.put(n, m);
            return m;
        }
        return this.getDefaultMaterial();
    }

    @Override
    public Material getOtherMaterial(Object3D o) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getRnaStemMaterial(RnaStem3D s) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getRnaStrandMaterial(RnaStrand s) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getStrandJunctionMaterial(StrandJunction3D j) {
        return this.getDefaultMaterial();
    }

    private Nucleotide3D getNucleotide(Object3D o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Nucleotide3D) {
            return (Nucleotide3D)o;
        }
        return this.getNucleotide(o.getParent());
    }

    @Override
    public void reset() {
        this.nMap.clear();
    }
}

