/*
 * Decompiled with CFR 0.152.
 */
package viewer.rnadesign;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.graphics.ColorVector;
import viewer.graphics.Configurable;
import viewer.graphics.Material;
import viewer.rnadesign.RNAColorModel;

public class AtomColorModel
extends RNAColorModel
implements Configurable {
    private JFrame frame;
    private ColorVector carbonColor = new ColorVector(0.4, 0.4, 0.4, 1.0);
    private ColorVector hydrogenColor = new ColorVector(1.0, 1.0, 1.0, 1.0);
    private ColorVector nitrogenColor = new ColorVector(0.0, 0.0, 1.0, 1.0);
    private ColorVector sulfurColor = new ColorVector(1.0, 1.0, 0.0, 1.0);
    private ColorVector oxygenColor = new ColorVector(1.0, 0.0, 0.0, 1.0);
    private ColorVector phosphorusColor = new ColorVector(1.0, 0.4, 0.8, 1.0);
    private ColorVector defaultColor = new ColorVector(1.0, 1.0, 1.0, 1.0);

    public AtomColorModel(Color color) {
    }

    public Material getMaterial(Object3D o1, Object3D o2) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getMaterial(Link l) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getAtomMaterial(Atom3D atom) {
        ColorVector color;
        Material material = this.getDefaultMaterial();
        char atomType = AtomTools.getElementChar(atom);
        switch (atomType) {
            case 'H': {
                color = this.hydrogenColor;
                break;
            }
            case 'C': {
                color = this.carbonColor;
                break;
            }
            case 'N': {
                color = this.nitrogenColor;
                break;
            }
            case 'O': {
                color = this.oxygenColor;
                break;
            }
            case 'S': {
                color = this.sulfurColor;
                break;
            }
            case 'P': {
                color = this.phosphorusColor;
                break;
            }
            default: {
                color = this.defaultColor;
            }
        }
        color.setAlpha(0.6);
        material.setDiffuse(color);
        color.setAlpha(0.4);
        material.setSpecular(color);
        return material;
    }

    @Override
    public Material getBranchDescriptorMaterial(BranchDescriptor3D b) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getKissingLoopMaterial(KissingLoop3D k) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getNucleotideMaterial(Nucleotide3D n) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getOtherMaterial(Object3D o) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getRnaStemMaterial(RnaStem3D s) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getRnaStrandMaterial(RnaStrand s) {
        return this.getDefaultMaterial();
    }

    @Override
    public Material getStrandJunctionMaterial(StrandJunction3D j) {
        return this.getDefaultMaterial();
    }

    @Override
    public void launchConfigurationGUI() {
        this.frame = new JFrame("Choose the preferred atom colors");
        this.frame.setLayout(new BorderLayout());
        JTabbedPane atomTabs = new JTabbedPane();
        JPanel hydrogen = new JPanel();
        Color init = new Color((float)this.hydrogenColor.getRed(), (float)this.hydrogenColor.getGreen(), (float)this.hydrogenColor.getBlue());
        final JColorChooser hydrogenChooser = new JColorChooser(init);
        hydrogen.add(hydrogenChooser);
        atomTabs.add("Hydrogen", hydrogen);
        JPanel carbon = new JPanel();
        init = new Color((float)this.carbonColor.getRed(), (float)this.carbonColor.getGreen(), (float)this.carbonColor.getBlue());
        final JColorChooser carbonChooser = new JColorChooser(init);
        carbon.add(carbonChooser);
        atomTabs.add("Carbon", carbon);
        JPanel nitrogen = new JPanel();
        init = new Color((float)this.nitrogenColor.getRed(), (float)this.nitrogenColor.getGreen(), (float)this.nitrogenColor.getBlue());
        final JColorChooser nitrogenChooser = new JColorChooser(init);
        nitrogen.add(nitrogenChooser);
        atomTabs.add("Nitrogen", nitrogen);
        JPanel oxygen = new JPanel();
        init = new Color((float)this.oxygenColor.getRed(), (float)this.oxygenColor.getGreen(), (float)this.oxygenColor.getBlue());
        final JColorChooser oxygenChooser = new JColorChooser(init);
        oxygen.add(oxygenChooser);
        atomTabs.add("Oxygen", oxygen);
        JPanel sulfur = new JPanel();
        init = new Color((float)this.sulfurColor.getRed(), (float)this.sulfurColor.getGreen(), (float)this.sulfurColor.getBlue());
        final JColorChooser sulfurChooser = new JColorChooser(init);
        sulfur.add(sulfurChooser);
        atomTabs.add("Sulfur", sulfur);
        JPanel phosphorus = new JPanel();
        init = new Color((float)this.phosphorusColor.getRed(), (float)this.phosphorusColor.getGreen(), (float)this.phosphorusColor.getBlue());
        final JColorChooser phosphorusChooser = new JColorChooser(init);
        phosphorus.add(phosphorusChooser);
        atomTabs.add("Phosphorus", phosphorus);
        this.frame.add((Component)atomTabs, "North");
        JPanel buttonPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomColorModel.this.frame.setVisible(false);
                AtomColorModel.this.frame = null;
            }
        });
        buttonPanel.add(cancelButton);
        JButton configureButton = new JButton("Apply Changes");
        configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color t = hydrogenChooser.getColor();
                AtomColorModel.this.hydrogenColor = new ColorVector((double)t.getRed() / 255.0, (double)t.getGreen() / 255.0, (double)t.getBlue() / 255.0, 1.0);
                t = carbonChooser.getColor();
                AtomColorModel.this.carbonColor = new ColorVector((double)t.getRed() / 255.0, (double)t.getGreen() / 255.0, (double)t.getBlue() / 255.0, 1.0);
                t = nitrogenChooser.getColor();
                AtomColorModel.this.nitrogenColor = new ColorVector((double)t.getRed() / 255.0, (double)t.getGreen() / 255.0, (double)t.getBlue() / 255.0, 1.0);
                t = oxygenChooser.getColor();
                AtomColorModel.this.oxygenColor = new ColorVector((double)t.getRed() / 255.0, (double)t.getGreen() / 255.0, (double)t.getBlue() / 255.0, 1.0);
                t = sulfurChooser.getColor();
                AtomColorModel.this.sulfurColor = new ColorVector((double)t.getRed() / 255.0, (double)t.getGreen() / 255.0, (double)t.getBlue() / 255.0, 1.0);
                t = phosphorusChooser.getColor();
                AtomColorModel.this.phosphorusColor = new ColorVector((double)t.getRed() / 255.0, (double)t.getGreen() / 255.0, (double)t.getBlue() / 255.0, 1.0);
                AtomColorModel.this.frame.setVisible(false);
                AtomColorModel.this.frame = null;
            }
        });
        buttonPanel.add(configureButton);
        this.frame.add((Component)buttonPanel, "South");
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(2);
        this.frame.pack();
    }
}

