/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import javax.media.opengl.GL;
import tools3d.Vector4D;
import viewer.graphics.DefaultObjectManipulator;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.SolidMeshRenderer;

public class ObjectTranslationManipulator
extends DefaultObjectManipulator {
    private static final Mesh CYLINDER = PrimitiveFactory.generateCylinder(new Vector4D(1.0, 0.0, 0.0, 0.0), 0.125, 2.0, 1, 8);
    private static final Mesh CONE = PrimitiveFactory.generateCone(new Vector4D(1.0, 0.0, 0.0, 0.0), 0.25, 0.5, 8);
    private static final Mesh PLANE = PrimitiveFactory.generateSheet(new Vector4D(0.0, 1.0, 0.0, 0.0), 2.0 / Math.sqrt(2.0), 2.0 / Math.sqrt(2.0), 1, 1);
    private static final MeshRenderer cylinderRenderer = new SolidMeshRenderer(CYLINDER);
    private static final MeshRenderer coneRenderer = new SolidMeshRenderer(CONE);
    private static final MeshRenderer planeRenderer = new SolidMeshRenderer(PLANE);

    public ObjectTranslationManipulator(Vector4D position) {
        super(position);
    }

    @Override
    public void render(GL gl) {
        Material material;
        Material material2;
        double x = this.getPosition().getX();
        double y = this.getPosition().getY();
        double z = this.getPosition().getZ();
        if (this.isXAxisEnabled()) {
            material2 = this.getXAxisMaterial();
            Material.renderMaterial(gl, material2);
            gl.glPushMatrix();
            gl.glTranslated(x + 1.0, y, z);
            cylinderRenderer.render(gl);
            gl.glTranslated(1.0, 0.0, 0.0);
            coneRenderer.render(gl);
            gl.glPopMatrix();
        }
        if (this.isYAxisEnabled()) {
            material2 = this.getYAxisMaterial();
            Material.renderMaterial(gl, material2);
            gl.glPushMatrix();
            gl.glTranslated(x, y + 1.0, z);
            gl.glRotated(90.0, 0.0, 0.0, 1.0);
            cylinderRenderer.render(gl);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslated(x, y + 2.0, z);
            gl.glRotated(90.0, 0.0, 0.0, 1.0);
            coneRenderer.render(gl);
            gl.glPopMatrix();
        }
        if (this.isZAxisEnabled()) {
            material2 = this.getZAxisMaterial();
            Material.renderMaterial(gl, material2);
            gl.glPushMatrix();
            gl.glTranslated(x, y, z + 1.0);
            gl.glRotated(90.0, 0.0, 1.0, 0.0);
            cylinderRenderer.render(gl);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslated(x, y, z + 2.0);
            gl.glRotated(-90.0, 0.0, 1.0, 0.0);
            coneRenderer.render(gl);
            gl.glPopMatrix();
        }
        double hSL = 2.0 / Math.sqrt(2.0) / 2.0;
        if (this.isXyPlaneEnabled()) {
            material = this.getXyPlaneMaterial();
            Material.renderMaterial(gl, material);
            gl.glPushMatrix();
            gl.glTranslated(x + hSL, y + hSL, z);
            gl.glRotated(90.0, 1.0, 0.0, 0.0);
            planeRenderer.render(gl);
            gl.glRotated(180.0, 1.0, 0.0, 0.0);
            planeRenderer.render(gl);
            gl.glPopMatrix();
        }
        if (this.isXzPlaneEnabled()) {
            material = this.getXzPlaneMaterial();
            Material.renderMaterial(gl, material);
            gl.glPushMatrix();
            gl.glTranslated(x + hSL, y, z + hSL);
            planeRenderer.render(gl);
            gl.glRotated(180.0, 0.0, 0.0, 1.0);
            planeRenderer.render(gl);
            gl.glPopMatrix();
        }
        if (this.isYzPlaneEnabled()) {
            material = this.getYzPlaneMaterial();
            Material.renderMaterial(gl, material);
            gl.glPushMatrix();
            gl.glTranslated(x, y + hSL, z + hSL);
            gl.glRotated(90.0, 0.0, 0.0, 1.0);
            planeRenderer.render(gl);
            gl.glRotated(180.0, 0.0, 0.0, 1.0);
            planeRenderer.render(gl);
            gl.glPopMatrix();
        }
    }
}

