/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.awt.Color;
import java.awt.Dimension;
import javax.media.opengl.GL;
import tools3d.Vector4D;
import viewer.graphics.Material;
import viewer.graphics.RenderableModel;

public class Grid
implements RenderableModel {
    private Dimension size = new Dimension(100, 100);
    private Dimension spacing = new Dimension(20, 20);
    private Color color = new Color(255, 255, 255, 127);
    private Material material = new Material(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private Vector4D u;
    private Vector4D v;
    private Vector4D position;

    public Grid(Vector4D u, Vector4D v, Vector4D position, Dimension size) {
        this.u = u;
        this.v = v;
        this.position = position;
        this.size = size;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Vector4D getU() {
        return this.u;
    }

    public void setU(Vector4D u) {
        this.u = u;
    }

    public Vector4D getV() {
        return this.v;
    }

    public void setV(Vector4D v) {
        this.v = v;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public Dimension getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Dimension spacing) {
        this.spacing = spacing;
    }

    public Vector4D getPosition() {
        return this.position;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setPosition(Vector4D position) {
        this.position = position;
    }

    @Override
    public void render(GL gl) {
        double gridHeight;
        gl.glColor4d(this.color.getRed() / 255, this.color.getGreen() / 255, this.color.getBlue() / 255, this.color.getAlpha() / 255);
        gl.glMaterialfv(1032, 4608, this.material.getAmbient().buffer());
        gl.glMaterialfv(1032, 4609, this.material.getDiffuse().buffer());
        gl.glMaterialfv(1032, 4610, this.material.getSpecular().buffer());
        gl.glMaterialfv(1032, 5632, this.material.getEmissive().buffer());
        gl.glMaterialf(1032, 5633, (float)this.material.getHighlight());
        gl.glLineWidth(1.0f);
        Vector4D normal = this.u.cross(this.v);
        normal.normalize();
        gl.glBegin(1);
        double width = this.size.width / 2;
        double height = this.size.height / 2;
        Vector4D ep1 = new Vector4D(this.u.getX() * width + this.position.getX() - height * this.v.getX(), this.u.getY() * width + this.position.getY() - height * this.v.getY(), this.u.getZ() * width + this.position.getZ() - height * this.v.getZ(), 0.0);
        Vector4D ep2 = new Vector4D(this.u.getX() * width * -1.0 + this.position.getX() - height * this.v.getX(), this.u.getY() * width * -1.0 + this.position.getY() - height * this.v.getY(), this.u.getZ() * width * -1.0 + this.position.getZ() - height * this.v.getZ(), 0.0);
        Vector4D increment = new Vector4D(this.v.getX() * (double)this.spacing.height, this.v.getY() * (double)this.spacing.height, this.v.getZ() * (double)this.spacing.height, 0.0);
        for (gridHeight = 0.0; gridHeight < (double)this.size.height; gridHeight += (double)this.spacing.height) {
            gl.glNormal3d(normal.getX(), normal.getY(), normal.getZ());
            gl.glVertex3d(ep1.getX(), ep1.getY(), ep1.getZ());
            gl.glNormal3d(normal.getX(), normal.getY(), normal.getZ());
            gl.glVertex3d(ep2.getX(), ep2.getY(), ep2.getZ());
            ep1.add(increment);
            ep2.add(increment);
        }
        ep1 = new Vector4D(this.v.getX() * height + this.position.getX() - width * this.u.getX(), this.v.getY() * height + this.position.getY() - width * this.u.getY(), this.v.getZ() * height + this.position.getZ() - width * this.u.getZ(), 0.0);
        ep2 = new Vector4D(this.v.getX() * height * -1.0 + this.position.getX() - width * this.u.getX(), this.v.getY() * height * -1.0 + this.position.getY() - width * this.u.getY(), this.v.getZ() * height * -1.0 + this.position.getZ() - width * this.u.getZ(), 0.0);
        increment = new Vector4D(this.u.getX() * (double)this.spacing.width, this.u.getY() * (double)this.spacing.width, this.u.getZ() * (double)this.spacing.width, 0.0);
        for (gridHeight = 0.0; gridHeight < (double)this.size.width; gridHeight += (double)this.spacing.width) {
            gl.glVertex3d(ep1.getX(), ep1.getY(), ep1.getZ());
            gl.glVertex3d(ep2.getX(), ep2.getY(), ep2.getZ());
            ep1.add(increment);
            ep2.add(increment);
        }
        gl.glEnd();
    }
}

