/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import javax.media.opengl.GL;
import tools3d.AABBBoundingVolume;
import tools3d.BoundingVolume;
import tools3d.CollisionDetectionTools;
import tools3d.Vector4D;
import viewer.graphics.ObjectManipulatorPlanes;

public class DefaultObjectManipulator
extends ObjectManipulatorPlanes {
    private AABBBoundingVolume xAxisVolume;
    private AABBBoundingVolume yAxisVolume;
    private AABBBoundingVolume zAxisVolume;
    private Vector4D xyPlaneDiagonal;
    private Vector4D xzPlaneDiagonal;
    private Vector4D yzPlaneDiagonal;
    public static final double BV_WIDTH = 0.25;
    public static final double BV_LENGTH = 2.0;
    public static final double DIAGONAL_LENGTH = 2.0;
    private AABBBoundingVolume boundingVolume;

    public DefaultObjectManipulator(Vector4D position) {
        this.setPosition(position);
    }

    @Override
    public BoundingVolume getBoundingVolume() {
        return this.boundingVolume;
    }

    @Override
    public void setPosition(Vector4D position) {
        super.setPosition(position);
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        Vector4D c1 = new Vector4D(x, y - 0.25, z - 0.25, 1.0);
        Vector4D c2 = new Vector4D(x + 2.0, y + 0.25, z + 0.25, 1.0);
        this.xAxisVolume = new AABBBoundingVolume(c1, c2);
        c1 = new Vector4D(x - 0.25, y, z - 0.25, 1.0);
        c2 = new Vector4D(x + 0.25, y + 2.0, z + 0.25);
        this.yAxisVolume = new AABBBoundingVolume(c1, c2);
        c1 = new Vector4D(x - 0.25, y - 0.25, z, 1.0);
        c2 = new Vector4D(x + 0.25, y + 0.25, z + 2.0, 1.0);
        this.zAxisVolume = new AABBBoundingVolume(c1, c2);
        double n = 2.0 / Math.sqrt(2.0);
        this.xyPlaneDiagonal = new Vector4D(n, n, 0.0, 0.0);
        this.xyPlaneDiagonal.setX(this.xyPlaneDiagonal.getX() + x);
        this.xyPlaneDiagonal.setY(this.xyPlaneDiagonal.getY() + y);
        this.xyPlaneDiagonal.setZ(z);
        this.xyPlaneDiagonal.setW(1.0);
        this.xzPlaneDiagonal = new Vector4D(n, 0.0, n, 0.0);
        this.xzPlaneDiagonal.setX(this.xzPlaneDiagonal.getX() + x);
        this.xzPlaneDiagonal.setY(y);
        this.xzPlaneDiagonal.setZ(this.xzPlaneDiagonal.getZ() + z);
        this.xzPlaneDiagonal.setW(1.0);
        this.yzPlaneDiagonal = new Vector4D(0.0, n, n, 0.0);
        this.yzPlaneDiagonal.setX(x);
        this.yzPlaneDiagonal.setY(this.yzPlaneDiagonal.getY() + y);
        this.yzPlaneDiagonal.setZ(this.yzPlaneDiagonal.getZ() + z);
        this.yzPlaneDiagonal.setW(1.0);
        this.boundingVolume = new AABBBoundingVolume(new Vector4D(x - 0.25, y - 0.25, z - 0.25, 1.0), new Vector4D(x + 2.0, y + 2.0, z + 2.0, 1.0));
    }

    @Override
    public int getIntersectionPlane(Vector4D ray, Vector4D origin) {
        int mask = 0;
        Vector4D pointOnPlane = this.xyPlaneDiagonal.minus(this.getPosition());
        double d = -1.0 * pointOnPlane.dot(CollisionDetectionTools.Z_AXIS);
        Vector4D intersection = CollisionDetectionTools.linePlaneIntersection(ray, origin, CollisionDetectionTools.Z_AXIS, d);
        if (intersection != null && intersection.getX() > this.getPosition().getX() && intersection.getX() < this.xyPlaneDiagonal.getX() && intersection.getY() > this.getPosition().getY() && intersection.getY() < this.xyPlaneDiagonal.getY()) {
            mask |= 1;
        }
        if ((intersection = CollisionDetectionTools.linePlaneIntersection(ray, origin, CollisionDetectionTools.Y_AXIS, d = -1.0 * (pointOnPlane = this.xzPlaneDiagonal.minus(this.getPosition())).dot(CollisionDetectionTools.Y_AXIS))) != null && intersection.getX() > this.getPosition().getX() && intersection.getX() < this.xzPlaneDiagonal.getX() && intersection.getZ() > this.getPosition().getZ() && intersection.getZ() < this.xzPlaneDiagonal.getZ()) {
            mask |= 2;
        }
        if ((intersection = CollisionDetectionTools.linePlaneIntersection(ray, origin, CollisionDetectionTools.X_AXIS, d = -1.0 * (pointOnPlane = this.yzPlaneDiagonal.minus(this.getPosition())).dot(CollisionDetectionTools.X_AXIS))) != null && intersection.getY() > this.getPosition().getY() && intersection.getY() < this.yzPlaneDiagonal.getY() && intersection.getZ() > this.getPosition().getZ() && intersection.getZ() < this.yzPlaneDiagonal.getZ()) {
            mask |= 4;
        }
        return mask;
    }

    @Override
    public int getIntersectionAxis(Vector4D ray, Vector4D origin) {
        int mask = 0;
        if (this.xAxisVolume.intersectRay(ray, origin)) {
            mask |= 1;
        }
        if (this.yAxisVolume.intersectRay(ray, origin)) {
            mask |= 2;
        }
        if (this.zAxisVolume.intersectRay(ray, origin)) {
            mask |= 4;
        }
        return mask;
    }

    @Override
    public void render(GL gl) {
    }
}

