/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.util.ArrayList;
import tools3d.Vector4D;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.Material;
import viewer.graphics.Mesh;

public class DefaultAdvancedMesh
implements AdvancedMesh {
    private ArrayList<Vector4D> vertices = new ArrayList();
    private ArrayList<Vector4D> normals = new ArrayList();
    private ArrayList<Material> materials = new ArrayList();
    private ArrayList<int[]> points = new ArrayList();
    private ArrayList<int[]> lines = new ArrayList();
    private ArrayList<int[]> triangles = new ArrayList();
    private ArrayList<int[]> quads = new ArrayList();
    private ArrayList<int[]> polygons = new ArrayList();
    private double pointSize = 1.0;
    private double lineWidth = 1.0;

    public int[][] getPolygons(int sides) {
        ArrayList<int[]> list = null;
        switch (sides) {
            case 1: {
                list = this.points;
                break;
            }
            case 2: {
                list = this.lines;
                break;
            }
            case 3: {
                list = this.triangles;
                break;
            }
            case 4: {
                list = this.quads;
                break;
            }
            default: {
                list = this.polygons;
            }
        }
        int[][] a = new int[list.size()][];
        list.toArray((T[])a);
        return a;
    }

    @Override
    public Material getVertexMaterial(int vertex) {
        return this.materials.get(vertex);
    }

    public void setVertexMaterial(int vertex, Material material) {
        this.materials.set(vertex, material);
    }

    @Override
    public Vector4D getNormal(int index) {
        return this.normals.get(index);
    }

    @Override
    public Vector4D[] getNormals() {
        Vector4D[] array = new Vector4D[this.normals.size()];
        this.normals.toArray(array);
        return array;
    }

    @Override
    public int[] getGeometryElement(int index) {
        return this.getGeometryElements()[index];
    }

    public int[] getLine(int index) {
        return this.lines.get(index);
    }

    public int[] getPoint(int index) {
        return this.points.get(index);
    }

    public int[] getTriangle(int index) {
        return this.triangles.get(index);
    }

    public int[] getQuad(int index) {
        return this.quads.get(index);
    }

    @Override
    public int getPolygonCount() {
        return this.polygons.size();
    }

    @Override
    public int getPointCount() {
        return this.points.size();
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    @Override
    public int getTriangleCount() {
        return this.triangles.size();
    }

    @Override
    public int getQuadCount() {
        return this.quads.size();
    }

    @Override
    public int getPolygonSideCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getPolygons() {
        int[][] array = new int[this.polygons.size()][];
        this.polygons.toArray((T[])array);
        return array;
    }

    @Override
    public int[][] getLines() {
        int[][] array = new int[this.lines.size()][];
        this.lines.toArray((T[])array);
        return array;
    }

    @Override
    public int[][] getPoints() {
        int[][] array = new int[this.points.size()][];
        this.points.toArray((T[])array);
        return array;
    }

    @Override
    public int[][] getQuads() {
        int[][] array = new int[this.quads.size()][];
        this.quads.toArray((T[])array);
        return array;
    }

    @Override
    public int[][] getTriangles() {
        int[][] array = new int[this.triangles.size()][];
        this.triangles.toArray((T[])array);
        return array;
    }

    @Override
    public Vector4D getVertex(int index) {
        return this.vertices.get(index);
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public Vector4D[] getVertices() {
        Vector4D[] array = new Vector4D[this.vertices.size()];
        this.vertices.toArray(array);
        return array;
    }

    public int add(Vector4D vertex, Vector4D normal, Material material) {
        int ret = this.vertices.size();
        this.vertices.add(vertex);
        this.normals.add(normal);
        this.materials.add(material);
        return ret;
    }

    public void add(Mesh mesh, Material material) {
        int i;
        int offset = this.getVertexCount();
        int[][] elements = (int[][])mesh.getGeometryElements().clone();
        for (i = 0; i < mesh.getVertexCount(); ++i) {
            this.add((Vector4D)mesh.getVertex(i).clone(), (Vector4D)mesh.getNormal(i).clone(), material);
        }
        for (i = 0; i < elements.length; ++i) {
            int j = 0;
            while (j < elements[i].length) {
                int[] nArray = elements[i];
                int n = j++;
                nArray[n] = nArray[n] + offset;
            }
            this.add(elements[i]);
        }
    }

    public void add(AdvancedMesh mesh) {
        int i;
        int offset = this.getVertexCount();
        int[][] elements = (int[][])mesh.getGeometryElements().clone();
        for (i = 0; i < mesh.getVertexCount(); ++i) {
            this.add((Vector4D)mesh.getVertex(i).clone(), (Vector4D)mesh.getNormal(i).clone(), (Material)mesh.getVertexMaterial(i).clone());
        }
        for (i = 0; i < elements.length; ++i) {
            int j = 0;
            while (j < elements[i].length) {
                int[] nArray = elements[i];
                int n = j++;
                nArray[n] = nArray[n] + offset;
            }
            this.add(elements[i]);
        }
    }

    public void add(int[] polygon) {
        switch (polygon.length) {
            case 1: {
                this.points.add(polygon);
                break;
            }
            case 2: {
                this.lines.add(polygon);
                break;
            }
            case 3: {
                this.triangles.add(polygon);
                break;
            }
            case 4: {
                this.quads.add(polygon);
                break;
            }
            default: {
                this.polygons.add(polygon);
            }
        }
    }

    @Override
    public int getGeometryElementCount() {
        return this.lines.size() + this.points.size() + this.triangles.size() + this.quads.size() + this.polygons.size();
    }

    @Override
    public int[][] getGeometryElements() {
        ArrayList<int[]> all = new ArrayList<int[]>(this.getGeometryElementCount());
        all.addAll(this.points);
        all.addAll(this.lines);
        all.addAll(this.triangles);
        all.addAll(this.quads);
        all.addAll(this.polygons);
        int[][] array = new int[all.size()][];
        all.toArray((T[])array);
        return array;
    }

    @Override
    public Object clone() {
        DefaultAdvancedMesh mesh = new DefaultAdvancedMesh();
        mesh.add(this);
        return mesh;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public double getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(double pointSize) {
        this.pointSize = pointSize;
    }

    public void addPoint(Vector4D vertex, Vector4D normal, Material material) {
        int index = this.vertices.size();
        this.vertices.add(vertex);
        this.normals.add(normal);
        int[] a = new int[]{index};
        this.points.add(a);
        this.materials.add(material);
    }
}

