/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph.rna;

import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStrand;
import tools3d.Matrix4D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import viewer.graph.LinkRenderableGraph;
import viewer.graph.RenderableGraph;
import viewer.graph.RenderableGraphImp;
import viewer.graph.RendererBinarySwitchGraph;
import viewer.graph.TransformGraph;
import viewer.graph.rna.ArrowBranchDescriptorRendererGraph;
import viewer.graph.rna.CartoonBackboneRendererGraph;
import viewer.graph.rna.RibbonBackboneRenderer;
import viewer.graph.rna.RnaRendererGraphController;
import viewer.graph.rna.StickNucleotideRendererGraph;
import viewer.graph.rna.TranslatedSphericalAtomRenderer;
import viewer.rnadesign.AvailableRenderers;

public class RenderableGraphFactory {
    public static RnaRendererGraphController generate(Object3DGraphController controller, AvailableRenderers renderer) {
        RenderableGraphImp graph = new RenderableGraphImp();
        RnaRendererGraphController rnaController = new RnaRendererGraphController();
        RendererBinarySwitchGraph strands = new RendererBinarySwitchGraph(new RnaRendererGraphController.StrandPredicate(rnaController));
        RendererBinarySwitchGraph nucleotides = new RendererBinarySwitchGraph(new RnaRendererGraphController.NucleotidePredicate(rnaController));
        RendererBinarySwitchGraph atoms = new RendererBinarySwitchGraph(new RnaRendererGraphController.AtomPredicate(rnaController));
        RendererBinarySwitchGraph links = new RendererBinarySwitchGraph(new RnaRendererGraphController.LinkPredicate(rnaController));
        RendererBinarySwitchGraph branchDescriptors = new RendererBinarySwitchGraph(new RnaRendererGraphController.BranchDescriptorPredicate(rnaController));
        graph.addChild(strands);
        graph.addChild(nucleotides);
        graph.addChild(atoms);
        System.out.println("Adding link renderer!");
        graph.addChild(links);
        System.out.println("Adding branch descriptor renderer!");
        graph.addChild(branchDescriptors);
        RenderableGraphFactory.generate(controller.getGraph().getGraph(), renderer, strands, nucleotides, atoms);
        RenderableGraphFactory.generate(controller.getLinks(), renderer, links);
        System.out.println("Strand renderer children: " + strands.size());
        System.out.println("Nucleotide renderer children: " + nucleotides.size());
        System.out.println("Atom renderer children: " + atoms.size());
        System.out.println("Branch descriptor renderer children: " + branchDescriptors.size());
        System.out.println("Link renderer children: " + links.size() + " generated from " + controller.getLinks().size() + " links.");
        rnaController.setRoot(graph);
        rnaController.setRenderer(renderer);
        rnaController.setMeshCached(true);
        return rnaController;
    }

    private static void generate(LinkSet linkSet, AvailableRenderers renderer, RenderableGraph links) {
        for (int i = 0; i < linkSet.size(); ++i) {
            Link linkInstance = linkSet.get(i);
            links.addChild(new LinkRenderableGraph(linkInstance));
        }
    }

    private static void generate(Object3D object, AvailableRenderers renderer, RenderableGraph strands, RenderableGraph nucleotides, RenderableGraph atoms) {
        RenderableGraph graph;
        if (object instanceof RnaStrand) {
            graph = RenderableGraphFactory.generate((RnaStrand)object, renderer);
            if (graph != null) {
                strands.addChild(graph);
            }
        } else if (object instanceof Nucleotide3D) {
            graph = RenderableGraphFactory.generate((Nucleotide3D)object, renderer);
            if (graph != null) {
                nucleotides.addChild(graph);
            }
        } else if (object instanceof Atom3D && (graph = RenderableGraphFactory.generate((Atom3D)object, renderer)) != null) {
            atoms.addChild(graph);
        }
        if (object instanceof BranchDescriptor3D && (graph = RenderableGraphFactory.generate((BranchDescriptor3D)object, renderer)) != null) {
            atoms.addChild(graph);
        }
        for (int i = 0; i < object.size(); ++i) {
            RenderableGraphFactory.generate(object.getChild(i), renderer, strands, nucleotides, atoms);
        }
    }

    public static RenderableGraph generate(Nucleotide3D n, AvailableRenderers renderer) {
        switch (renderer) {
            case Cartoon: {
                return new StickNucleotideRendererGraph(n, true, true, true);
            }
            case Stick: 
            case BallAndStick: {
                return new StickNucleotideRendererGraph(n);
            }
        }
        return null;
    }

    public static RenderableGraph generate(RnaStrand s, AvailableRenderers renderer) {
        switch (renderer) {
            case Cartoon: {
                return new CartoonBackboneRendererGraph(s);
            }
            case Ribbon: {
                return new RibbonBackboneRenderer(s);
            }
        }
        return null;
    }

    public static RenderableGraph generate(BranchDescriptor3D bd, AvailableRenderers renderer) {
        switch (renderer) {
            case Cartoon: {
                return new ArrowBranchDescriptorRendererGraph(bd);
            }
            case Ribbon: {
                return new ArrowBranchDescriptorRendererGraph(bd);
            }
        }
        return null;
    }

    public static RenderableGraph generate(Atom3D a, AvailableRenderers renderer) {
        switch (renderer) {
            case BallAndStick: 
            case Ball: {
                TranslatedSphericalAtomRenderer g = new TranslatedSphericalAtomRenderer(a);
                return g;
            }
        }
        return null;
    }

    private static TransformGraph computeTranslationNode(Vector4D from, Vector4D to) {
        Vector4D diff = to.minus(from);
        Matrix4D transform = new Matrix4D(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, diff.getX(), diff.getY(), diff.getZ(), 1.0);
        return new TransformGraph(transform);
    }

    private static void configureController(RnaRendererGraphController controller, AvailableRenderers renderer) {
        switch (renderer) {
            case Cartoon: {
                controller.setRenderAtoms(true);
                break;
            }
            case Ribbon: {
                controller.setRenderAtoms(false);
                controller.setRenderNucleotides(false);
                break;
            }
            case Stick: {
                controller.setRenderAtoms(false);
                break;
            }
            case BallAndStick: {
                break;
            }
            case Ball: {
                controller.setRenderNucleotides(false);
                controller.setRenderStrands(false);
                break;
            }
        }
    }
}

