/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph.rna;

import java.awt.Color;
import java.util.ArrayList;
import rnadesign.rnamodel.BranchDescriptor3D;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.splines.StandaloneSplineFactory;
import viewer.graph.rna.BranchDescriptorRendererGraph;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.AdvancedMeshTools;
import viewer.graphics.DefaultAdvancedMesh;
import viewer.graphics.Material;
import viewer.graphics.Mesh;
import viewer.graphics.MeshOperations;
import viewer.graphics.PrimitiveFactory;

public class ArrowBranchDescriptorRendererGraph
extends BranchDescriptorRendererGraph {
    public ArrowBranchDescriptorRendererGraph(BranchDescriptor3D branchDescriptor) {
        super(branchDescriptor);
    }

    @Override
    public AdvancedMesh generateMesh() {
        Material material;
        BranchDescriptor3D branchDescriptor = this.getBranchDescriptor();
        CoordinateSystem cs = branchDescriptor.getCoordinateSystem();
        assert (cs != null);
        ArrayList backbone = new ArrayList(2);
        ArrayList bases = new ArrayList(2);
        Vector3D[] points = new Vector3D[]{cs.getPosition(), cs.getPosition().plus(cs.getZ())};
        Vector3D[] b = new Vector3D[2];
        assert (cs.getX() != null);
        assert (cs.getY() != null);
        b[0] = points[0].plus(cs.getX());
        b[1] = points[1].plus(cs.getX().mul(0.5));
        StandaloneSplineFactory factory = new StandaloneSplineFactory();
        Vector3D[] curve = factory.createCubic(points, this.getRefinement());
        DefaultAdvancedMesh mesh = new DefaultAdvancedMesh();
        if (this.getRefinementLevel() == 1) {
            int[] line;
            int i;
            material = new Material(Color.PINK, true);
            material.getEmissive().setAlpha(1.0);
            mesh.add(new Vector4D(curve[0]), new Vector4D(0.0, 0.0, -1.0, 0.0), material);
            for (i = 0; i < curve.length - 1; ++i) {
                mesh.add(new Vector4D(curve[i + 1]), new Vector4D(0.0, 0.0, -1.0, 0.0), material);
                line = new int[]{i, i + 1};
                mesh.add(line);
            }
            if (b.length == points.length) {
                for (i = 0; i < b.length; ++i) {
                    mesh.add(new Vector4D(b[i]), new Vector4D(0.0, 0.0, -1.0, 0.0), material);
                    line = new int[]{i * this.getRefinement(), i + curve.length};
                    mesh.add(line);
                }
            }
        } else {
            Vector4D[] polygon = new Vector4D[]{new Vector4D(0.433, 0.25, 0.0, 0.0), new Vector4D(0.0, 0.5, 0.0, 0.0), new Vector4D(-0.433, 0.25, 0.0, 0.0), new Vector4D(-0.433, -0.25, 0.0, 0.0), new Vector4D(0.0, -0.5, 0.0, 0.0), new Vector4D(0.433, -0.25, 0.0, 0.0)};
            Vector4D normal = new Vector4D(0.0, 0.0, -1.0, 0.0);
            Material material2 = this.getColorModel().getMaterial(branchDescriptor);
            mesh.add(MeshOperations.extend(polygon, normal, curve), material2);
            if (b.length == points.length) {
                for (int i = 0; i < b.length; ++i) {
                    Vector4D axis = new Vector4D(b[i].minus(points[i]));
                    axis.setW(0.0);
                    double length = axis.length();
                    axis.normalize();
                    Vector4D midpoint = new Vector4D(b[i].plus(points[i]).mul(0.5));
                    midpoint.setW(1.0);
                    Mesh cylinder = PrimitiveFactory.generateCylinder(axis, 0.25, length, 1, 6);
                    MeshOperations.translateMesh(cylinder, midpoint);
                    mesh.add(cylinder, material2);
                }
            }
        }
        if (this.getBranchDescriptor().isSelected() && this.getRefinementLevel() != 1) {
            material = new Material();
            material.setEmissive(1.0, 1.0, 0.0, 0.0);
            DefaultAdvancedMesh combo = new DefaultAdvancedMesh();
            combo.add(mesh);
            combo.add(AdvancedMeshTools.extractCage(mesh, material));
            return combo;
        }
        return mesh;
    }

    private int getRefinement() {
        if (this.getRefinementLevel() == 1 || this.getRefinementLevel() == 2) {
            return 3;
        }
        return 5;
    }
}

