/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import viewer.graph.RenderableGraph;

public class RenderableGraphImp
implements RenderableGraph {
    private ArrayList<RenderableGraph> children = new ArrayList();
    private RenderableGraph parent = null;
    private boolean marked = false;

    @Override
    public boolean isMarked() {
        return this.marked;
    }

    @Override
    public void setMark(boolean mark) {
        this.marked = mark;
    }

    @Override
    public void addChild(RenderableGraph graph) {
        this.children.add(graph);
        graph.setParent(this);
    }

    @Override
    public void insertChild(RenderableGraph graph, int index) {
        this.children.add(index, graph);
        graph.setParent(this);
    }

    @Override
    public RenderableGraph getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public List<RenderableGraph> getChildren() {
        return (List)this.children.clone();
    }

    @Override
    public String getClassName() {
        return "RenderableGraphImp";
    }

    @Override
    public int getDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        return 1 + this.getParent().getDepth();
    }

    @Override
    public String getName() {
        if (this.parent == null) {
            return this.getClassName() + "0";
        }
        return this.parent.getName() + "." + this.getClassName() + this.getIndex();
    }

    @Override
    public RenderableGraph getParent() {
        return this.parent;
    }

    @Override
    public void setParent(RenderableGraph parent) {
        this.parent = parent;
    }

    @Override
    public int indexOf(RenderableGraph graph) {
        return this.children.indexOf(graph);
    }

    @Override
    public boolean removeChild(RenderableGraph graph) {
        return this.children.remove(graph);
    }

    @Override
    public RenderableGraph removeChild(int index) {
        return this.children.remove(index);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public int getIndex() {
        if (this.getParent() == null) {
            return 0;
        }
        return this.getParent().indexOf(this);
    }

    @Override
    public void render(GL gl) {
        for (RenderableGraph g : this.children) {
            g.render(gl);
        }
    }

    @Override
    public RenderableGraph replaceChild(RenderableGraph graph, int index) {
        graph.setParent(this);
        return this.children.set(index, graph);
    }

    @Override
    public RenderableGraph replace(RenderableGraph graph) {
        this.getParent().addChild(graph);
        this.getParent().removeChild(this);
        for (int i = 0; i < this.size(); ++i) {
            graph.addChild(this.getChild(i));
        }
        return this;
    }

    @Override
    public Object clone() {
        RenderableGraph graph = null;
        try {
            graph = (RenderableGraph)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            graph.replaceChild((RenderableGraph)this.getChild(i).clone(), i);
        }
        return graph;
    }

    @Override
    public void update() {
    }
}

