/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph;

import javax.media.opengl.GL;
import tools3d.objects3d.Object3D;
import viewer.graph.Object3DRenderableGraph;
import viewer.graphics.AdvancedMesh;
import viewer.graphics.AdvancedSolidMeshRenderer;
import viewer.graphics.AdvancedWireframeMeshRenderer;
import viewer.graphics.ColorModel;
import viewer.graphics.MeshCacheable;
import viewer.graphics.MeshRenderer;

public abstract class CacheableObject3DRenderableGraph
extends Object3DRenderableGraph
implements MeshCacheable {
    private AdvancedMesh mesh;

    public CacheableObject3DRenderableGraph(Object3D object) {
        super(object);
    }

    @Override
    public String getClassName() {
        return "CacheableObject3DRenderableGraph";
    }

    @Override
    public void render(GL gl) {
        AdvancedMesh m = this.isMeshCached() ? this.getCachedMesh() : this.generateMesh();
        MeshRenderer renderer = this.isWireframeMode() ? new AdvancedWireframeMeshRenderer(m) : new AdvancedSolidMeshRenderer(m);
        renderer.render(gl);
        super.render(gl);
    }

    @Override
    public void setColorModel(ColorModel model) {
        super.setColorModel(model);
        this.updateMesh();
    }

    @Override
    public AdvancedMesh getCachedMesh() {
        return this.mesh;
    }

    @Override
    public boolean isMeshCached() {
        return this.mesh != null;
    }

    @Override
    public void setMeshCached(boolean meshCached) {
        this.mesh = meshCached ? this.generateMesh() : null;
    }

    @Override
    public void updateMesh() {
        if (this.isMeshCached()) {
            this.mesh = this.generateMesh();
        }
    }

    @Override
    public void update() {
        this.updateMesh();
    }

    @Override
    public void setRefinementLevel(int refinementLevel) {
        super.setRefinementLevel(refinementLevel);
        if (this.isMeshCached()) {
            this.updateMesh();
        }
    }

    public abstract AdvancedMesh generateMesh();

    @Override
    public Object clone() {
        CacheableObject3DRenderableGraph graph = (CacheableObject3DRenderableGraph)super.clone();
        return graph;
    }
}

