/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import viewer.components.ViewManipulator;
import viewer.components.ViewOrientationSelector;
import viewer.display.DefaultDecorator;
import viewer.display.Display;
import viewer.display.DisplayDecorator;
import viewer.display.DisplayFactory;
import viewer.display.DisplayOptions;
import viewer.graph.rna.RnaRendererGraphController;
import viewer.graphics.LODCapable;
import viewer.view.PerspectiveView;
import viewer.view.ViewOrientation;

public class SmallViewerPanelDecorator
implements DisplayDecorator {
    private ViewManipulator manipulator;
    private static final String LOD_COARSE = "Coarse";
    private static final String LOD_MEDIUM = "Medium";
    private static final String LOD_FINE = "Fine";

    public ViewManipulator getManipulator() {
        return this.manipulator;
    }

    @Override
    public JPanel decorateDisplay(final Display display, ViewOrientation orientation) {
        final JPanel panel = new JPanel(new BorderLayout());
        Display graphicDisplay = display;
        ViewOrientation finalOrientation = orientation;
        final JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        this.manipulator = null;
        this.manipulator = orientation.isPerspective() ? new ViewManipulator((PerspectiveView)display.getView()) : new ViewManipulator(display.getView());
        display.setTranslateListener(this.manipulator.new ViewManipulator.TranslateListener());
        display.setZoomListener(this.manipulator.new ViewManipulator.ZoomListener());
        display.setRotateListener(this.manipulator.new ViewManipulator.RotateListener());
        final JButton options = new JButton("Options");
        final ViewOrientationSelector comboBox = new ViewOrientationSelector(orientation);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewOrientation orientation = (ViewOrientation)((Object)comboBox.getSelectedItem());
                Display c = (Display)((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
                panel.remove(c);
                final Display display = DisplayFactory.createDisplay(orientation, true);
                if (c.getModel() != null) {
                    display.setModel(c.getModel(), false);
                    display.addRenderable(c.getRenderables());
                } else {
                    display.setModel(null, false);
                }
                if (c.getOwner() != null) {
                    c.getOwner().registerDisplay(display);
                    c.getOwner().unregisterDisplay(c);
                }
                panel.add((Component)display, "Center");
                top.remove(2);
                ViewManipulator manipulator = null;
                manipulator = orientation.isPerspective() ? new ViewManipulator((PerspectiveView)display.getView()) : new ViewManipulator(display.getView());
                top.add((Component)manipulator, 2);
                options.removeActionListener(options.getActionListeners()[0]);
                options.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DisplayOptions dialog = new DisplayOptions(display);
                        dialog.createAndShowGUI();
                    }
                });
                panel.revalidate();
            }
        });
        Object[] objects = new Object[]{LOD_COARSE, LOD_MEDIUM, LOD_FINE};
        final JComboBox<Object> lodBox = new JComboBox<Object>(objects);
        lodBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = lodBox.getSelectedItem();
                RnaRendererGraphController lod = (RnaRendererGraphController)display.getModel();
                if (selected == SmallViewerPanelDecorator.LOD_COARSE) {
                    lod.setRefinementLevel(1);
                } else if (selected == SmallViewerPanelDecorator.LOD_MEDIUM) {
                    lod.setRefinementLevel(2);
                } else {
                    lod.setRefinementLevel(3);
                }
                lod.updateMeshes();
                display.display();
            }
        });
        if (display.getModel() instanceof LODCapable) {
            RnaRendererGraphController lod = (RnaRendererGraphController)display.getModel();
            int refinement = lod.getRefinementLevel();
            if (refinement == 1) {
                lodBox.setSelectedIndex(0);
            } else if (refinement == 2) {
                lodBox.setSelectedIndex(1);
            } else {
                lodBox.setSelectedIndex(2);
            }
        }
        JButton shrinkScreen = new JButton("View Size");
        shrinkScreen.setToolTipText("Switch the screen size to either full screen or half screen");
        shrinkScreen.addActionListener(new ActionListener(){
            boolean fullScreen = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayFactory.setDecorator(new DefaultDecorator());
            }
        });
        top.add((Component)comboBox, 0);
        top.add(Box.createHorizontalGlue(), 1);
        top.add((Component)new JLabel("Graphical Detail "), 2);
        top.add((Component)lodBox, 3);
        top.add((Component)this.manipulator, 4);
        top.add((Component)shrinkScreen, 5);
        options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayOptions dialog = new DisplayOptions(display);
                dialog.createAndShowGUI();
            }
        });
        top.add((Component)options, 6);
        Dimension dim = new Dimension(250, 0);
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.add(Box.createRigidArea(dim), "West");
        tempPanel.add((Component)graphicDisplay, "Center");
        tempPanel.add(Box.createRigidArea(dim), "East");
        panel.add((Component)top, "North");
        panel.add((Component)tempPanel, "Center");
        return panel;
    }
}

