/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import viewer.display.DefaultDecorator;
import viewer.display.Display;
import viewer.display.DisplayDecorator;
import viewer.display.DisplayGridLayout;
import viewer.display.DisplayLayoutRequest;
import viewer.display.MultiDisplay;
import viewer.display.OrthogonalDisplay;
import viewer.display.PerspectiveDisplay;
import viewer.view.LeftHandedViewFactory;
import viewer.view.ViewFactory;
import viewer.view.ViewOrientation;

public class DisplayFactory {
    private static ViewFactory viewFactory = new LeftHandedViewFactory();
    private static boolean decorated = true;
    private static boolean resizable = true;
    private static boolean preserveDimensions = false;
    private static DisplayDecorator decorator = new DefaultDecorator();
    public static final Dimension PREFAB_DIMENSION = new Dimension(800, 600);

    public static DisplayDecorator getDecorator() {
        return decorator;
    }

    public static void setDecorator(DisplayDecorator decorator) {
        DisplayFactory.decorator = decorator;
    }

    public static void setViewFactory(ViewFactory viewFactory) {
        DisplayFactory.viewFactory = viewFactory;
    }

    public static ViewFactory getViewFactory() {
        return viewFactory;
    }

    public static boolean isDecorated() {
        return decorated;
    }

    public static void setDecorated(boolean decorated) {
        DisplayFactory.decorated = decorated;
    }

    public static boolean isResizable() {
        return resizable;
    }

    public void setResizable(boolean resizable) {
        DisplayFactory.resizable = resizable;
    }

    public void setPreserveDimensions(boolean preserveDimensions) {
        DisplayFactory.preserveDimensions = preserveDimensions;
    }

    public boolean getPreserveDimensions() {
        return preserveDimensions;
    }

    public static Display createDisplay(ViewOrientation orientation) {
        return DisplayFactory.createDisplay(orientation, false);
    }

    public static Display createDisplay(ViewOrientation orientation, boolean manipulatable) {
        Display display = null;
        switch (orientation) {
            case Left: {
                display = new OrthogonalDisplay(viewFactory.createLeftView());
                break;
            }
            case Right: {
                display = new OrthogonalDisplay(viewFactory.createRightView());
                break;
            }
            case Top: {
                display = new OrthogonalDisplay(viewFactory.createTopView());
                break;
            }
            case Bottom: {
                display = new OrthogonalDisplay(viewFactory.createBottomView());
                break;
            }
            case Front: {
                display = new OrthogonalDisplay(viewFactory.createFrontView());
                break;
            }
            case Back: {
                display = new OrthogonalDisplay(viewFactory.createBackView());
                break;
            }
            case PerspectiveTop: {
                display = new PerspectiveDisplay(viewFactory.createPerspectiveView(LeftHandedViewFactory.TOP_PERSPECTIVE_VIEW));
                break;
            }
            case PerspectiveHorizon: {
                display = new PerspectiveDisplay(viewFactory.createPerspectiveView(LeftHandedViewFactory.HORIZON_PERSPECTIVE_VIEW));
            }
        }
        if (!manipulatable) {
            return display;
        }
        return display;
    }

    private static JPanel decorateDisplay(Display display, ViewOrientation orientation) {
        return decorator.decorateDisplay(display, orientation);
    }

    public static MultiDisplay createDisplay(DisplayLayoutRequest request) {
        MultiDisplay panel = new MultiDisplay();
        panel.setPreferredSize(request.getDisplaySize());
        int numberViews = request.getNumberViews();
        for (int i = 0; i < numberViews; ++i) {
            for (int j = i + 1; j < numberViews; ++j) {
                Rectangle v2;
                Rectangle v1 = request.getViewBounds(i);
                if (!v1.intersects(v2 = request.getViewBounds(j))) continue;
                throw new InvalidRequest("View bounds intersect with one another");
            }
        }
        ArrayList<JPanel> panels = new ArrayList<JPanel>();
        for (int i = 0; i < numberViews; ++i) {
            JPanel displayPanel = new JPanel(new BorderLayout());
            Display display = DisplayFactory.createDisplay(request.getViewOrientation(i), true);
            panel.registerDisplay(display);
            panel.registerDisplay(display);
            if (decorated) {
                displayPanel = DisplayFactory.decorateDisplay(display, request.getViewOrientation(i));
            } else {
                displayPanel.add(display);
            }
            displayPanel.setBounds(request.getViewBounds(i));
            displayPanel.setPreferredSize(request.getViewBounds(i).getSize());
            panels.add(displayPanel);
        }
        if (resizable) {
            DisplayFactory.assemble(panels);
        }
        for (JPanel p : panels) {
            panel.add(p);
        }
        if (panels.size() == 1) {
            panel.setLayout(new BorderLayout());
            panel.add((Component)panels.get(0));
            return panel;
        }
        final Dimension requestDimension = request.getDisplaySize();
        panel.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String s, Component c) {
            }

            @Override
            public void layoutContainer(Container container) {
                Dimension size = container.getSize();
                double scaleWidth = (double)size.width / (double)requestDimension.width;
                double scaleHeight = (double)size.height / (double)requestDimension.height;
                for (Component c : container.getComponents()) {
                    Point location = c.getLocation();
                    Dimension d = c.getPreferredSize();
                    c.setLocation((int)(scaleWidth * (double)location.x), (int)(scaleHeight * (double)location.y));
                    c.setSize((int)(scaleWidth * (double)d.width), (int)(scaleHeight * (double)d.height));
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container c) {
                return this.preferredLayoutSize(c);
            }

            @Override
            public Dimension preferredLayoutSize(Container c) {
                int maxX = 0;
                int maxY = 0;
                for (Component component : c.getComponents()) {
                    Dimension d = component.getPreferredSize();
                    if (component.getX() + (int)d.getWidth() > maxX) {
                        maxX = component.getX() + (int)d.getWidth();
                    }
                    if (component.getY() + (int)d.getHeight() <= maxY) continue;
                    maxY = component.getY() + (int)d.getHeight();
                }
                return new Dimension(maxX, maxY);
            }

            @Override
            public void removeLayoutComponent(Component c) {
            }
        });
        return panel;
    }

    private static void assemble(List<JPanel> panels) {
        if (panels.size() == 1) {
            return;
        }
        JPanel panel1 = null;
        JPanel panel2 = null;
        boolean breakOut = false;
        for (int i = 0; i < panels.size(); ++i) {
            for (int j = i + 1; j < panels.size(); ++j) {
                Dimension newSize;
                JPanel panel;
                JSplitPane splitPane;
                Rectangle r1 = panels.get(i).getBounds();
                Rectangle r2 = panels.get(j).getBounds();
                if (r1.x == r2.x && r1.width == r2.width && (r1.y - r2.y == r2.height || r2.y - r1.y == r1.height)) {
                    if (r1.y < r2.y) {
                        panel1 = panels.get(i);
                        panel2 = panels.get(j);
                    } else {
                        panel1 = panels.get(j);
                        panel2 = panels.get(i);
                    }
                    panels.remove(panel1);
                    panels.remove(panel2);
                    splitPane = new JSplitPane(0, panel1, panel2);
                    splitPane.setOneTouchExpandable(true);
                    panel = new JPanel(new BorderLayout());
                    panel.add(splitPane);
                    splitPane.addHierarchyListener(new HierarchyListener(){

                        @Override
                        public void hierarchyChanged(HierarchyEvent e) {
                            if (e.getChangeFlags() == 4L) {
                                splitPane.setDividerLocation(0.5);
                                splitPane.removeHierarchyListener(this);
                            }
                        }
                    });
                    newSize = new Dimension(r1.width, r1.height + r2.height);
                    panel.setSize(newSize);
                    panel.setPreferredSize(newSize);
                    panel.setLocation(r1.x, r1.y > r2.y ? r2.y : r1.y);
                    panels.add(panel);
                    breakOut = true;
                    break;
                }
                if (r1.y != r2.y || r1.height != r2.height || r1.x - r2.x != r2.width && r2.x - r1.x != r1.width) continue;
                if (r1.x < r2.x) {
                    panel1 = panels.get(i);
                    panel2 = panels.get(j);
                } else {
                    panel1 = panels.get(j);
                    panel2 = panels.get(i);
                }
                panel1 = panels.get(i);
                panel2 = panels.get(j);
                panels.remove(panel1);
                panels.remove(panel2);
                splitPane = new JSplitPane(1, panel1, panel2);
                panel = new JPanel(new BorderLayout());
                panel.add(splitPane);
                splitPane.setOneTouchExpandable(true);
                splitPane.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (e.getChangeFlags() == 4L) {
                            splitPane.setDividerLocation(0.5);
                            splitPane.removeHierarchyListener(this);
                        }
                    }
                });
                newSize = new Dimension(r1.width + r2.width, r1.height);
                panel.setSize(newSize);
                panel.setPreferredSize(newSize);
                panel.setLocation(r1.x > r2.x ? r2.x : r1.x, r1.y);
                panels.add(panel);
                breakOut = true;
                break;
            }
            if (breakOut) break;
        }
        if (breakOut) {
            DisplayFactory.assemble(panels);
        }
    }

    public static class InvalidRequest
    extends RuntimeException {
        public InvalidRequest(String s) {
            super(s);
        }
    }

    public static enum PrefabricatedDisplays {
        FourQuadrants(4),
        VerticalSplit(2),
        HorizontalSplit(2),
        TopAndTwoBottoms(3),
        Single(1),
        BottomAndTwoTops(3),
        LeftAndTwoRights(3),
        RightAndTwoLefts(3);

        private int viewCount;
        private static final int[][] FOUR_QUADRANTS;
        private static final int[][] VERTICAL_SPLIT;
        private static final int[][] HORIZONTAL_SPLIT;
        private static final int[][] TOP_AND_TWO_BOTTOMS;
        private static final int[][] SINGLE;
        private static final int[][] BOTTOM_AND_TWO_TOPS;
        private static final int[][] LEFT_AND_TWO_RIGHTS;
        private static final int[][] RIGHT_AND_TWO_LEFTS;
        private static final Dimension DEFAULT_SIZE;
        private static final ViewOrientation[] DEFAULT_ORIENTATIONS;

        public int getViewCount() {
            return this.viewCount;
        }

        private PrefabricatedDisplays(int viewCount) {
            this.viewCount = viewCount;
        }

        public MultiDisplay getDefaultDisplay() {
            return this.getDisplay(DEFAULT_ORIENTATIONS);
        }

        public MultiDisplay getDisplay(ViewOrientation[] orientations) {
            return this.getDisplay(orientations, DEFAULT_SIZE);
        }

        public MultiDisplay getDisplay(ViewOrientation[] orientations, Dimension size) {
            switch (this) {
                case FourQuadrants: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(FOUR_QUADRANTS, orientations, size));
                }
                case VerticalSplit: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(VERTICAL_SPLIT, orientations, size));
                }
                case HorizontalSplit: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(HORIZONTAL_SPLIT, orientations, size));
                }
                case TopAndTwoBottoms: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(TOP_AND_TWO_BOTTOMS, orientations, size));
                }
                case Single: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(SINGLE, orientations, size));
                }
                case BottomAndTwoTops: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(BOTTOM_AND_TWO_TOPS, orientations, size));
                }
                case LeftAndTwoRights: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(LEFT_AND_TWO_RIGHTS, orientations, size));
                }
                case RightAndTwoLefts: {
                    return DisplayFactory.createDisplay(new DisplayGridLayout(RIGHT_AND_TWO_LEFTS, orientations, size));
                }
            }
            return null;
        }

        static {
            FOUR_QUADRANTS = new int[][]{{1, 2}, {3, 4}};
            VERTICAL_SPLIT = new int[][]{{1, 2}};
            HORIZONTAL_SPLIT = new int[][]{{1}, {2}};
            TOP_AND_TWO_BOTTOMS = new int[][]{{1, 1}, {2, 3}};
            SINGLE = new int[][]{{1}};
            BOTTOM_AND_TWO_TOPS = new int[][]{{1, 2}, {3, 3}};
            LEFT_AND_TWO_RIGHTS = new int[][]{{1, 2}, {1, 3}};
            RIGHT_AND_TWO_LEFTS = new int[][]{{1, 2}, {3, 2}};
            DEFAULT_SIZE = new Dimension(800, 600);
            DEFAULT_ORIENTATIONS = new ViewOrientation[]{ViewOrientation.PerspectiveTop, ViewOrientation.Top, ViewOrientation.Left, ViewOrientation.Back};
        }
    }
}

