/*
 * Decompiled with CFR 0.152.
 */
package viewer.deprecated;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.swing.JOptionPane;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import tools3d.splines.StandaloneSplineFactory;
import viewer.deprecated.RNAModelRenderer;
import viewer.graphics.ColorModel;
import viewer.graphics.Colorable;
import viewer.graphics.CylindricalCurveRenderer;
import viewer.graphics.DefaultColorModel;
import viewer.graphics.Material;
import viewer.graphics.RenderableModel;

public class NucleotideBackboneRenderer
implements RNAModelRenderer,
Colorable,
ModelChangeListener {
    private StandaloneSplineFactory factory = new StandaloneSplineFactory();
    private Object3DGraphController controller;
    private boolean wireframeMode = false;
    private static final int REFINEMENT = 3;
    private Map<Object3D, RenderableModel> renderers = new HashMap<Object3D, RenderableModel>();
    private ColorModel colorModel = new DefaultColorModel();

    public NucleotideBackboneRenderer(Object3DGraphController controller) {
        this.controller = controller;
        controller.addModelChangeListener(this);
        this.assembleMeshes();
    }

    public NucleotideBackboneRenderer(Object3DGraphController controller, ColorModel colorModel) {
        this(controller);
        this.colorModel = colorModel;
    }

    @Override
    public Object3DGraphController getController() {
        return this.controller;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.assembleMeshes();
    }

    private void assembleMeshes() {
        this.renderers.clear();
        this.assembleMeshes(this.controller.getGraph().getGraph());
    }

    private void assembleMeshes(Object3D o) {
        if (o instanceof RnaStrand) {
            this.assembleRnaStrandMesh((RnaStrand)o);
            return;
        }
        if (o.size() > 0) {
            for (int i = 0; i < o.size(); ++i) {
                this.assembleMeshes(o.getChild(i));
            }
        }
    }

    private void assembleRnaStrandMesh(RnaStrand strand) {
        ArrayList<Vector3D> backbone = new ArrayList<Vector3D>();
        ArrayList<Vector3D> bases = new ArrayList<Vector3D>();
        ArrayList<Boolean> purines = new ArrayList<Boolean>();
        for (int i = 0; i < strand.getResidueCount(); ++i) {
            Residue3D residue = strand.getResidue3D(i);
            if (!(residue instanceof Nucleotide3D)) continue;
            Nucleotide3D n = (Nucleotide3D)residue;
            if (n.getSymbol().getCharacter() == 'A' || n.getSymbol().getCharacter() == 'G') {
                purines.add(true);
            } else {
                purines.add(false);
            }
            try {
                bases.add(this.assembleNucleotideMesh(n, backbone).getPosition());
                continue;
            }
            catch (RnaModelException e) {
                System.out.println(e.getMessage());
            }
        }
        if (backbone.size() < 2) {
            JOptionPane.showMessageDialog(null, "Cartoon renderer cannot render molecule. Please switch to a different renderer.");
            return;
        }
        Vector3D[] points = new Vector3D[backbone.size()];
        backbone.toArray(points);
        Vector3D[] b = new Vector3D[bases.size()];
        bases.toArray(b);
        Vector3D[] curve = this.factory.createCubic(points, 3);
        this.renderers.put(strand, new CylindricalCurveRenderer(curve, 0.5, 6, this.wireframeMode));
    }

    private Atom3D assembleNucleotideMesh(Nucleotide3D n, List<Vector3D> backbone) throws RnaModelException {
        HashSet<Atom3D> atoms = new HashSet<Atom3D>();
        if (n.getIndexOfChild("O5*") < 0) {
            throw new RnaModelException("Atom O5* not a member of nucleotide");
        }
        backbone.add(n.getChild("O5*").getPosition());
        for (int i = 0; i < n.getAtomCount(); ++i) {
            Atom3D atom = n.getAtom(i);
            if (!NucleotideTools.isBaseAtom(atom)) continue;
            atoms.add(atom);
        }
        return (Atom3D)n.getChild("C1*");
    }

    @Override
    public boolean getRenderAtom() {
        return false;
    }

    @Override
    public boolean getRenderBranchDescriptor() {
        return false;
    }

    @Override
    public boolean getRenderKissingLoop() {
        return false;
    }

    @Override
    public boolean getRenderLinks() {
        return true;
    }

    @Override
    public boolean getRenderNucleotide() {
        return true;
    }

    @Override
    public boolean getRenderOther() {
        return false;
    }

    @Override
    public boolean getRenderRNAStem() {
        return false;
    }

    @Override
    public boolean getRenderStrand() {
        return true;
    }

    @Override
    public boolean getRenderStrandJunction() {
        return false;
    }

    @Override
    public void renderAtom(Atom3D atom, GL gl) {
    }

    @Override
    public void renderBranchDescriptor(BranchDescriptor3D bd, GL gl) {
    }

    @Override
    public void renderKissingLoop(KissingLoop3D kl, GL gl) {
    }

    @Override
    public void renderOther(Object3D o, GL gl) {
    }

    @Override
    public void renderRNAStem(RnaStem3D stem, GL gl) {
    }

    @Override
    public void renderStrandJunction(StrandJunction3D sj, GL gl) {
    }

    @Override
    public void renderLink(Link link, GL gl) {
    }

    @Override
    public void renderNucleotide(Nucleotide3D n, GL gl) {
    }

    @Override
    public void renderRnaStrand(RnaStrand strand, GL gl) {
    }

    public void renderNucleotide(Nucleotide3D n, GL gl, List<Vector3D> backbone) {
    }

    @Override
    public void renderSelected(Object3D o, GL gl) {
    }

    @Override
    public void setController(Object3DGraphController controller) {
        this.controller = controller;
    }

    @Override
    public void setWireframeMode(boolean wireframeMode) {
        this.wireframeMode = wireframeMode;
        this.assembleMeshes();
    }

    @Override
    public void render(GL gl) {
        for (Map.Entry<Object3D, RenderableModel> e : this.renderers.entrySet()) {
            if (this.colorModel != null) {
                Material material = this.colorModel.getMaterial(e.getKey());
                Material.renderMaterial(gl, material);
            }
            e.getValue().render(gl);
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.colorModel = model;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

