/*
 * Decompiled with CFR 0.152.
 */
package viewer.deprecated;

import javax.media.opengl.GL;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.deprecated.ColorableRnaModelRenderer;
import viewer.deprecated.Cylinder;
import viewer.graphics.ColorModel;
import viewer.graphics.Mesh;
import viewer.graphics.MeshRenderer;
import viewer.graphics.PrimitiveFactory;
import viewer.graphics.SolidMeshRenderer;
import viewer.graphics.WireframeMeshRenderer;

public class DefaultRNAModelRenderer
extends ColorableRnaModelRenderer {
    private boolean renderAtom = true;
    private boolean renderNucleotides = true;
    private boolean renderBranchDescriptor = true;
    private boolean renderKissingLoop = true;
    private boolean renderLinks = true;
    private boolean renderOther = true;
    private boolean renderRNAStem = true;
    private boolean renderStrand = true;
    private boolean renderStrandJunction = true;
    private MeshRenderer renderer = null;

    public DefaultRNAModelRenderer(Object3DGraphController controller, ColorModel model) {
        super(controller, model);
        this.setWireframeMode(false);
    }

    public DefaultRNAModelRenderer(Object3DGraphController controller) {
        super(controller);
        this.setWireframeMode(false);
    }

    public DefaultRNAModelRenderer() {
        this.setWireframeMode(false);
    }

    @Override
    public void setWireframeMode(boolean wireframeMode) {
        super.setWireframeMode(wireframeMode);
        Mesh sphere = PrimitiveFactory.generateSphere(0.5, 4, 4);
        this.renderer = wireframeMode ? new WireframeMeshRenderer(sphere) : new SolidMeshRenderer(sphere);
    }

    @Override
    public boolean getRenderAtom() {
        return this.renderAtom;
    }

    public void setRenderAtom(boolean renderAtom) {
        this.renderAtom = renderAtom;
    }

    @Override
    public boolean getRenderBranchDescriptor() {
        return this.renderBranchDescriptor;
    }

    public void setRenderBranchDescriptor(boolean renderBranchDescriptor) {
        this.renderBranchDescriptor = renderBranchDescriptor;
    }

    @Override
    public boolean getRenderKissingLoop() {
        return this.renderKissingLoop;
    }

    public void setRenderKissingLoop(boolean renderKissingLoop) {
        this.renderKissingLoop = renderKissingLoop;
    }

    @Override
    public boolean getRenderLinks() {
        return this.renderLinks;
    }

    public void setRenderLinks(boolean renderLinks) {
        this.renderLinks = renderLinks;
    }

    @Override
    public boolean getRenderNucleotide() {
        return this.renderNucleotides;
    }

    public void setRenderNucleotide(boolean renderNucleotides) {
        this.renderNucleotides = renderNucleotides;
    }

    @Override
    public boolean getRenderOther() {
        return this.renderOther;
    }

    public void setRenderOther(boolean renderOther) {
        this.renderOther = renderOther;
    }

    @Override
    public boolean getRenderRNAStem() {
        return this.renderRNAStem;
    }

    public void setRenderRNAStem(boolean renderRNAStem) {
        this.renderRNAStem = renderRNAStem;
    }

    @Override
    public boolean getRenderStrand() {
        return this.renderStrand;
    }

    public void setRenderStrand(boolean renderStrand) {
        this.renderStrand = renderStrand;
    }

    @Override
    public boolean getRenderStrandJunction() {
        return this.renderStrandJunction;
    }

    public void setRenderStrandJunction(boolean renderStrandJunction) {
        this.renderStrandJunction = renderStrandJunction;
    }

    public void renderSphere(Object3D o, GL gl) {
        Vector3D p = o.getPosition();
        gl.glPushMatrix();
        gl.glTranslated(p.getX(), p.getY(), p.getZ());
        this.renderer.render(gl);
        gl.glPopMatrix();
    }

    @Override
    public void renderAtom(Atom3D atom, GL gl) {
        this.renderSphere(atom, gl);
    }

    @Override
    public void renderBranchDescriptor(BranchDescriptor3D bd, GL gl) {
        this.renderSphere(bd, gl);
    }

    @Override
    public void renderKissingLoop(KissingLoop3D kl, GL gl) {
        this.renderSphere(kl, gl);
    }

    @Override
    public void renderNucleotide(Nucleotide3D n, GL gl) {
        this.renderSphere(n, gl);
    }

    @Override
    public void renderOther(Object3D o, GL gl) {
        this.renderSphere(o, gl);
    }

    @Override
    public void renderRNAStem(RnaStem3D stem, GL gl) {
        this.renderSphere(stem, gl);
    }

    @Override
    public void renderRnaStrand(RnaStrand strand, GL gl) {
        this.renderSphere(strand, gl);
    }

    @Override
    public void renderStrandJunction(StrandJunction3D sj, GL gl) {
        this.renderSphere(sj, gl);
    }

    @Override
    public void renderLink(Link link, GL gl) {
        super.renderLink(link, gl);
        Vector4D p1 = new Vector4D(link.getObj1().getPosition());
        Vector4D p2 = new Vector4D(link.getObj2().getPosition());
        p1.setW(0.0);
        p2.setW(0.0);
        Cylinder c = new Cylinder(0.2, p2, p1);
    }
}

