/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.ConstraintDouble;
import generaltools.SimpleConstraintDouble;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.TorsionLink;

public class SimpleTorsionLink
extends SimpleLink
implements TorsionLink {
    private ConstraintDouble constraint;
    private Object3D obj3;
    private Object3D obj4;

    public SimpleTorsionLink(Object3D o1, Object3D o2, Object3D o3, Object3D o4, ConstraintDouble constraint) {
        super(o1, o2);
        this.obj3 = o3;
        this.obj4 = o4;
        this.constraint = constraint;
    }

    public SimpleTorsionLink(Object3D o1, Object3D o2, Object3D o3, Object3D o4, double min, double max) {
        super(o1, o2);
        this.obj3 = o3;
        this.obj4 = o4;
        this.constraint = new SimpleConstraintDouble(min, max);
    }

    @Override
    public ConstraintDouble getConstraint() {
        return this.constraint;
    }

    @Override
    public Object3D getObj3() {
        return this.obj3;
    }

    @Override
    public Object3D getObj4() {
        return this.obj4;
    }

    @Override
    public double computeError() {
        return this.computeError(this.getObj1().getPosition(), this.getObj2().getPosition(), this.getObj3().getPosition(), this.getObj4().getPosition());
    }

    @Override
    public double computeError(Vector3D v1, Vector3D v2, Vector3D v3, Vector3D v4) {
        double ang = Vector3D.torsionAngle(v1, v2, v3, v4);
        assert (ang >= 0.0);
        assert (ang <= Math.PI);
        double result = 0.0;
        if (ang < this.constraint.getMin()) {
            result = this.constraint.getMin() - ang;
        } else if (ang > this.constraint.getMax()) {
            result = ang - this.constraint.getMax();
        }
        assert (result >= 0.0);
        assert (result <= Math.PI);
        return result;
    }
}

