/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import tools3d.CoordinateSystem;
import tools3d.Positionable3D;
import tools3d.Vector3D;
import tools3d.objects3d.Primitive3D;

public class SimplePrimitive
implements Primitive3D {
    double zBufValue = 0.0;
    List<Vector3D> list = new ArrayList<Vector3D>();
    Color color = new Color(77, 77, 77);
    Vector3D position = new Vector3D(0.0, 0.0, 0.0);

    @Override
    public void activeTransform(CoordinateSystem cs) {
        assert (false);
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        assert (false);
    }

    public void add(Vector3D v) {
        this.list.add(v);
        this.update();
    }

    @Override
    public void clear() {
        this.list.clear();
        this.update();
    }

    @Override
    public Object clone() {
        assert (false);
        return this;
    }

    @Override
    public Object cloneDeep() {
        assert (false);
        return this;
    }

    @Override
    public int compareTo(Positionable3D p) {
        double val = this.zBufValue;
        double oVal = p.getZBufValue();
        if (val < oVal) {
            return -1;
        }
        if (val == oVal) {
            return 0;
        }
        return 1;
    }

    @Override
    public double distance(Positionable3D other) {
        return this.getPosition().minus(other.getPosition()).length();
    }

    @Override
    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Vector3D getPoint(int n) {
        return this.list.get(n);
    }

    @Override
    public boolean isValid() {
        return this.getPosition().isValid();
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public void setZBufValue(double z) {
        this.zBufValue = z;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void translate(Vector3D shift) {
        this.position.add(shift);
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).add(shift);
        }
    }

    private void update() {
        this.position.setX(0.0);
        this.position.setY(0.0);
        this.position.setZ(0.0);
        if (this.size() == 0) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.position.add(this.list.get(i));
        }
        this.position.scale(1.0 / (double)this.size());
    }
}

