/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import tools3d.objects3d.Link;
import tools3d.objects3d.MultiLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DSet;

public class SimpleMultiLink
implements MultiLink {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    List<Object3D> objects = new ArrayList<Object3D>();
    String name = "multilink";
    String typeName = "MultiLink";
    Properties properties;
    boolean finalObject = false;

    public SimpleMultiLink() {
    }

    public SimpleMultiLink(Object3D o1, Object3D o2) {
        this.addObj(o1);
        this.addObj(o2);
    }

    public SimpleMultiLink(MultiLink other) {
        this.setName(other.getName());
        for (int i = 0; i < other.size(); ++i) {
            this.addObj(other.getObj(i));
        }
    }

    @Override
    public void addObj(Object3D obj) {
        this.objects.add(obj);
    }

    @Override
    public double angle(Link other) {
        assert (false);
        return 0.0;
    }

    @Override
    public Object3DSet findCommon(Link other) {
        assert (false);
        return null;
    }

    @Override
    public void clear() {
        this.objects.clear();
        this.name = "";
    }

    @Override
    public Object clone() {
        return new SimpleMultiLink(this);
    }

    @Override
    public Object clone(Object3D newObj1, Object3D newObj2) {
        assert (false);
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof MultiLink) {
            MultiLink otherLink = (MultiLink)other;
            if (this.size() != otherLink.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (otherLink.getObj(i).equals(this.getObj(i))) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName1() {
        return this.getObjectName(this.getObj(0));
    }

    @Override
    public String getName2() {
        return this.getObjectName(this.getObj(1));
    }

    String getObjectName(Object3D o) {
        if (o == null) {
            return "__UNDEFINED";
        }
        return o.getFullName();
    }

    @Override
    public Object3D getObj1() {
        return this.objects.get(0);
    }

    @Override
    public Object3D getObj2() {
        return this.objects.get(1);
    }

    @Override
    public Object3D getObj(int n) {
        return this.objects.get(n);
    }

    @Override
    public Object3D getPartner(Object3D obj) {
        assert (false);
        return null;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isLinked(Object3D o1, Object3D o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return this.objects.contains(o1) && this.objects.contains(o2);
    }

    @Override
    public boolean isValid() {
        return this.size() > 1;
    }

    @Override
    public int linkOrder(Object3D o1) {
        int result = 0;
        String fn = o1.getFullName();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getObj(i).getFullName().equals(fn)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean links(String name) {
        assert (false);
        return false;
    }

    @Override
    public void read(InputStream is, Object3D tree) throws Object3DIOException {
        assert (false);
    }

    public void setFinalObject(boolean finalObject) {
        assert (false);
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public void replaceObjectInLink(Object3D oldObject, Object3D newObject) {
        assert (false);
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public void setObj1(Object3D o) {
        if (this.objects.size() > 0) {
            this.objects.set(0, o);
        } else {
            this.objects.add(o);
        }
    }

    @Override
    public void setObj2(Object3D o) {
        if (this.objects.size() > 1) {
            this.objects.set(1, o);
        } else if (this.objects.size() > 0) {
            this.objects.add(o);
        } else assert (false);
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    @Override
    public void setTypeName(String s) {
        this.name = s;
    }

    @Override
    public void swap() {
        assert (false);
    }

    @Override
    public String toString() {
        String result = "(MultiLink " + this.getName();
        for (int i = 0; i < this.size(); ++i) {
            result = result + " " + this.getObj(i).getFullName();
        }
        result = result + " )";
        return result;
    }
}

