/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.StringTools;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DCollector;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleObject3D;

public class SimpleLinkSet
implements LinkSet {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private List<Link> links = new ArrayList<Link>();

    @Override
    public LinkSet cloneDeep() {
        this.log.warning("Cloning a LinkSet could lead to outdated references. Be careful!!");
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < this.links.size(); ++i) {
            result.add(this.links.get(i));
        }
        return result;
    }

    @Override
    public LinkSet cloneDeep(Object3D root) {
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < this.size(); ++i) {
            Link link = this.get(i);
            SimpleLink newLink = new SimpleLink(root.getChild(link.getObj1()), root.getChild(link.getObj2()));
            result.add(newLink);
        }
        return result;
    }

    @Test(groups={"new"})
    public void testCloneDeep() {
        SimpleLinkSet test = new SimpleLinkSet();
        SimpleObject3D obj1 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
        obj1.setName("p1");
        SimpleObject3D obj2 = new SimpleObject3D(new Vector3D(1.0, 1.0, 1.0));
        obj2.setName("p2");
        SimpleObject3D obj3 = new SimpleObject3D(new Vector3D(2.0, 2.0, 2.0));
        obj3.setName("p3");
        SimpleLink link1 = new SimpleLink(obj1, obj2);
        SimpleLink link2 = new SimpleLink(obj2, obj3);
        SimpleObject3D root = new SimpleObject3D();
        root.insertChild(obj1);
        root.insertChild(obj2);
        root.insertChild(obj3);
        test.add(link1);
        test.add(link2);
        LinkSet result = test.cloneDeep(root);
        assert (result.size() == test.size());
        for (int i = 0; i < result.size(); ++i) {
            assert (result.get(i).getObj1().equals(test.get(i).getObj1()));
            assert (result.get(i).getObj2().equals(test.get(i).getObj2()));
        }
    }

    @Override
    public void add(Link link) {
        this.links.add(link);
    }

    @Override
    public void clear() {
        this.links.clear();
    }

    @Override
    public Link get(int n) throws IndexOutOfBoundsException {
        return this.links.get(n);
    }

    @Override
    public void merge(LinkSet otherLinks) {
        for (int i = 0; i < otherLinks.size(); ++i) {
            this.links.add(otherLinks.get(i));
        }
    }

    @Override
    public int size() {
        return this.links.size();
    }

    @Override
    public boolean contains(Link link) {
        for (int i = 0; i < this.links.size(); ++i) {
            if (!link.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Link find(Object3D obj1, Object3D obj2) {
        SimpleLink testLink = new SimpleLink(obj1, obj2);
        for (int i = 0; i < this.links.size(); ++i) {
            if (!((Object)testLink).equals(this.get(i))) continue;
            return this.get(i);
        }
        return null;
    }

    @Override
    public LinkSet findLinks(Object3D obj1, Object3D obj2) {
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isLinked(obj1, obj2)) continue;
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public LinkSet findLinks(Object3D obj) {
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).linkOrder(obj) <= 0) continue;
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public int getLinkRank(Object3D obj, Link link) {
        LinkSet links = this.findLinks(obj);
        for (int i = 0; i < links.size(); ++i) {
            if (links.get(i) != link) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLinkNumber(Object3D obj1, Object3D obj2) {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isLinked(obj1, obj2)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getLinkOrder(Object3D obj) {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i).linkOrder(obj);
        }
        return result;
    }

    @Override
    public void remove(Link link) {
        this.links.remove(link);
    }

    @Override
    public void removeAndAdd(Object3D objectTree, Object3DSet vertexSet) {
    }

    @Override
    public void removeBadLinks(Object3D tree) {
        Object3DCollector collector = Object3DCollector.collectAll(tree);
        for (int i = this.size() - 1; i >= 0; --i) {
            Link link = this.get(i);
            if (collector.contains(link.getObj1()) && collector.contains(link.getObj2())) continue;
            this.links.remove(link);
        }
    }

    @Override
    public String toString() {
        String result = "(LinkSet " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + ((Object)this.get(i)).toString() + " ";
        }
        result = result + ")";
        return result;
    }

    @Override
    public void read(InputStream is, Object3D tree) throws Object3DIOException {
        StringTools st = new StringTools();
        String expected = "(LinkSet";
        DataInputStream dis = new DataInputStream(is);
        String word = StringTools.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("LinkSet.read: " + expected + " excepted instead of " + word);
        }
        word = StringTools.readWord(dis);
        int numLinks = 0;
        try {
            numLinks = Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("createObject3DGraph: Could not parse number of children: " + word);
        }
        for (int i = 0; i < numLinks; ++i) {
            SimpleLink link = new SimpleLink();
            link.read(dis, tree);
            this.add(link);
        }
        expected = ")";
        word = StringTools.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("createObject3D: " + expected + " excepted instead of " + word);
        }
    }

    @Override
    public void replaceObjectInLinks(Object3D oldObject, Object3D newObject) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).replaceObjectInLink(oldObject, newObject);
        }
    }
}

