/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.StringTools;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import tools3d.Point;
import tools3d.Vector2;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DSet;

public class SimpleLink
implements Link {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    Object3D obj1;
    Object3D obj2;
    String name = "link";
    String typeName = "Link";
    Properties properties;
    boolean finalObject = false;

    public SimpleLink() {
    }

    public SimpleLink(Object3D o1, Object3D o2) {
        this.obj1 = o1;
        this.obj2 = o2;
    }

    public SimpleLink(String name, Point p1, Point p2) {
        assert (name != null);
        assert (p1 != null);
        assert (p2 != null);
        this.setName(name);
        this.obj1 = p1.toObject3D();
        this.obj2 = p2.toObject3D();
    }

    public SimpleLink(String name, Point p1, Point p2, boolean finalObject) {
        assert (name != null);
        assert (p1 != null);
        assert (p2 != null);
        this.setName(name);
        this.obj1 = p1.toObject3D();
        this.obj2 = p2.toObject3D();
        this.setFinalObject(finalObject);
    }

    public SimpleLink(Vector2 v) {
        assert (v != null);
        this.setTypeName("Vector");
        this.setObj1(v.getPoint().toObject3D());
        this.setObj2(v.getVectorPoint().toObject3D());
    }

    @Override
    public double angle(Link other) {
        Vector3D v2;
        Object3DSet common = this.findCommon(other);
        if (common.size() == 2) {
            return 0.0;
        }
        if (common.size() == 1) {
            Vector3D p0 = common.get(0).getPosition();
            Vector3D p1 = this.getPartner(common.get(0)).getPosition();
            Vector3D p2 = other.getPartner(common.get(0)).getPosition();
            return p1.minus(p0).angle(p2.minus(p0));
        }
        Vector3D v1 = this.getObj2().getPosition().minus(this.getObj1().getPosition());
        double a = v1.angle(v2 = other.getObj2().getPosition().minus(other.getObj1().getPosition()));
        if (a > 1.5707963267948966) {
            a -= 1.5707963267948966;
        }
        return a;
    }

    @Override
    public Object3DSet findCommon(Link other) {
        SimpleObject3DSet common = new SimpleObject3DSet();
        if (this.getObj1() == other.getObj1() || this.getObj1() == other.getObj2()) {
            common.add(this.getObj1());
        }
        if (this.getObj2() != this.getObj1() && (this.getObj2() == other.getObj1() || this.getObj2() == other.getObj2())) {
            common.add(this.getObj2());
        }
        return common;
    }

    @Override
    public void clear() {
        this.obj1 = null;
        this.obj2 = null;
        this.name = "";
    }

    @Override
    public Object clone() {
        SimpleLink l = new SimpleLink(this.getObj1(), this.getObj2());
        l.setName(new String(this.getName()));
        l.setTypeName(new String(this.getTypeName()));
        if (this.properties != null) {
            l.properties = (Properties)this.properties.clone();
        }
        return l;
    }

    @Override
    public Object clone(Object3D newObj1, Object3D newObj2) {
        SimpleLink l = (SimpleLink)this.clone();
        l.setObj1(newObj1);
        l.setObj2(newObj2);
        return l;
    }

    public boolean equals(Object other) {
        Link otherLink;
        return other instanceof Link && ((otherLink = (Link)other).getObj1().equals(this.getObj1()) && otherLink.getObj2().equals(this.getObj2()) || otherLink.getObj1().equals(this.getObj2()) && otherLink.getObj2().equals(this.getObj1()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName1() {
        return this.getObjectName(this.obj1);
    }

    @Override
    public String getName2() {
        return this.getObjectName(this.obj2);
    }

    @Override
    public Object3D getObj1() {
        return this.obj1;
    }

    @Override
    public Object3D getObj2() {
        return this.obj2;
    }

    String getObjectName(Object3D o) {
        if (o == null) {
            return "__UNDEFINED";
        }
        if (o instanceof Object3D) {
            return Object3DTools.getFullName(o);
        }
        return "_";
    }

    @Override
    public Object3D getPartner(Object3D obj) {
        if (obj == this.obj1) {
            return this.obj2;
        }
        if (obj == this.obj2) {
            return this.obj1;
        }
        return null;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isLinked(Object3D o1, Object3D o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return this.obj1 == o1 && this.obj2 == o2 || this.obj1 == o2 && this.obj2 == o1;
    }

    @Override
    public boolean isValid() {
        return this.obj1 != null && this.obj2 != null;
    }

    @Override
    public int linkOrder(Object3D o1) {
        int result = 0;
        if (this.obj1.getName().equals(o1.getName())) {
            ++result;
        }
        if (this.obj2.getName().equals(o1.getName())) {
            ++result;
        }
        return result;
    }

    @Override
    public boolean links(String name) {
        if (this.getName1() == name) {
            return true;
        }
        return this.getName2() == name;
    }

    @Override
    public void read(InputStream is, Object3D tree) throws Object3DIOException {
        StringTools st = new StringTools();
        DataInputStream dis = new DataInputStream(is);
        String expected = "(Link";
        String word = StringTools.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("SimpleLink.read: " + expected + " excepted instead of " + word);
        }
        String linkName = StringTools.readWord(dis);
        String name1 = StringTools.readWord(dis);
        String name2 = StringTools.readWord(dis);
        Object3D o1 = Object3DTools.findByFullName(tree, name1);
        if (o1 == null) {
            log.severe("Could not find " + name1);
            throw new Object3DIOException("SimpleLink.read: no object found with name: " + name1);
        }
        Object3D o2 = Object3DTools.findByFullName(tree, name2);
        if (o2 == null) {
            log.severe("Could not find " + name2);
            throw new Object3DIOException("SimpleLink.read: no object found with name: " + name2);
        }
        word = StringTools.readWord(dis);
        if (!word.equals(expected = ")")) {
            throw new Object3DIOException("SimpleLink.read: " + expected + " excepted instead of " + word);
        }
        this.setName(linkName);
        this.setObj1(o1);
        this.setObj2(o2);
    }

    public void setFinalObject(boolean finalObject) {
        this.finalObject = finalObject;
    }

    @Override
    public void replaceObjectInLink(Object3D oldObject, Object3D newObject) {
        if (this.obj1 == oldObject) {
            this.obj1 = newObject;
        }
        if (this.obj2 == oldObject) {
            this.obj2 = newObject;
        }
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public void setObj1(Object3D o) {
        this.obj1 = o;
    }

    @Override
    public void setObj2(Object3D o) {
        this.obj2 = o;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    @Override
    public void setTypeName(String s) {
        this.name = s;
    }

    @Override
    public void swap() {
        Object3D h = this.obj1;
        this.obj1 = this.obj2;
        this.obj2 = h;
    }

    @Override
    public String toString() {
        String result = "(Link " + this.getName() + " " + this.getObjectName(this.obj1) + " " + this.getObjectName(this.obj2);
        result = result + " )";
        return result;
    }
}

