/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.ConstraintDouble;
import generaltools.SimpleConstraintDouble;
import tools3d.Vector3D;
import tools3d.objects3d.AngleLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleLink;

public class SimpleAngleLink
extends SimpleLink
implements AngleLink {
    private ConstraintDouble constraint;
    private Object3D obj3;

    public SimpleAngleLink(Object3D o1, Object3D o2, Object3D _oCenter, ConstraintDouble constraint) {
        super(o1, o2);
        this.obj3 = _oCenter;
        this.constraint = constraint;
    }

    public SimpleAngleLink(Object3D o1, Object3D o2, Object3D _oCenter, double min, double max) {
        super(o1, o2);
        this.obj3 = _oCenter;
        this.constraint = new SimpleConstraintDouble(min, max);
    }

    @Override
    public ConstraintDouble getConstraint() {
        return this.constraint;
    }

    @Override
    public Object3D getObj3() {
        return this.obj3;
    }

    @Override
    public double computeError() {
        return this.computeError(this.getObj1().getPosition(), this.getObj2().getPosition(), this.getObj3().getPosition());
    }

    @Override
    public double computeError(Vector3D pos1, Vector3D pos2, Vector3D pos3) {
        Vector3D v1 = pos1.minus(pos3);
        Vector3D v2 = pos2.minus(pos3);
        double ang = v1.angle(v2);
        double result = 0.0;
        if (ang < this.constraint.getMin()) {
            result = this.constraint.getMin() - ang;
        } else if (ang > this.constraint.getMax()) {
            result = this.constraint.getMax() - ang;
        }
        return result;
    }
}

