/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.awt.Color;
import tools3d.CoordinateSystem;
import tools3d.Positionable3D;
import tools3d.Vector3D;
import tools3d.objects3d.Primitive3D;

public class Polygon3D
implements Primitive3D {
    double zBufValue = 0.0;
    Vector3D[] points;
    Color color;

    public Polygon3D(Vector3D[] _points, Color _color) {
        if (_points != null) {
            this.points = new Vector3D[_points.length];
            for (int i = 0; i < _points.length; ++i) {
                this.points[i] = (Vector3D)_points[i].clone();
            }
        } else {
            this.points = new Vector3D[0];
        }
        if (_color != null) {
            this.color = new Color(_color.getRed(), _color.getGreen(), _color.getBlue());
        }
    }

    @Override
    public void clear() {
        this.points = null;
        this.color = null;
    }

    @Override
    public void activeTransform(CoordinateSystem cs) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = cs.activeTransform(this.points[i]);
        }
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = cs.passiveTransform(this.points[i]);
        }
    }

    @Override
    public Object clone() {
        Polygon3D result = new Polygon3D(this.points, this.color);
        return result;
    }

    @Override
    public Object cloneDeep() {
        Vector3D[] newPoints = new Vector3D[this.points.length];
        for (int i = 0; i < newPoints.length; ++i) {
            newPoints[i] = new Vector3D(this.points[i]);
        }
        return new Polygon3D(newPoints, this.color);
    }

    @Override
    public int compareTo(Positionable3D o) {
        if (o instanceof Primitive3D) {
            double val = this.zBufValue;
            Primitive3D p = (Primitive3D)o;
            double oVal = p.getZBufValue();
            if (val < oVal) {
                return -1;
            }
            if (val == oVal) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    @Override
    public double distance(Positionable3D other) {
        return this.getPosition().minus(other.getPosition()).length();
    }

    @Override
    public Vector3D getPoint(int n) {
        return this.points[n];
    }

    @Override
    public Vector3D getPosition() {
        Vector3D sum = new Vector3D(0.0, 0.0, 0.0);
        if (this.points.length == 0) {
            return sum;
        }
        for (int i = 0; i < this.points.length; ++i) {
            sum.add(this.points[i]);
        }
        sum.mul(1.0 / (double)this.points.length);
        return sum;
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isValid() {
        return this.getPosition().isValid();
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public void setZBufValue(double z) {
        this.zBufValue = z;
    }

    @Override
    public int size() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length;
    }

    @Override
    public void translate(Vector3D shift) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = this.points[i].plus(shift);
        }
    }
}

