/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.Randomizer;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import tools3d.GeometryTools;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.PackageConstants;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DActionVisitor;
import tools3d.objects3d.Object3DNameCollector;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetSelected;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.SimpleObject3DSet;

public class Object3DTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static Random rnd = Randomizer.getInstance();
    public static boolean debugMode = false;
    public static final String ENDL = System.getProperty("line.separator");

    public static void addEnding(Object3D tree, String ending, Set<String> allowedNames, Set<String> forbiddenNames) {
        assert (tree != null);
        if (Object3DTools.checkPrintable(tree.getClassName(), allowedNames, forbiddenNames)) {
            tree.setName(tree.getName() + ending);
        }
        for (int i = 0; i < tree.size(); ++i) {
            Object3DTools.addEnding(tree.getChild(i), ending, allowedNames, forbiddenNames);
        }
    }

    public static void applySuperposition(Object3D obj, Matrix3D rot, Vector3D mc1, Vector3D mc2) {
        obj.translate(mc2.mul(-1.0));
        obj.rotate(Vector3D.ZVEC, rot);
        obj.translate(mc1);
    }

    public static boolean validateName(String name) {
        return name != null && name.length() > 0;
    }

    public static void applyTransformation(Object3D tree, SuperpositionResult superposition) {
        tree.setIsolatedPosition(superposition.returnTransformed(tree.getPosition()));
        for (int i = 0; i < tree.size(); ++i) {
            Object3DTools.applyTransformation(tree.getChild(i), superposition);
        }
    }

    public static void applySymmetry(Object3D tree, int symId) {
        tree.setIsolatedPosition(tree.getPosition(symId));
        for (int i = 0; i < tree.size(); ++i) {
            Object3DTools.applySymmetry(tree.getChild(i), symId);
        }
    }

    public static boolean isAllowedName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.indexOf(46) >= 0) {
            return false;
        }
        if (name.indexOf(44) >= 0) {
            return false;
        }
        return name.indexOf(36) < 0;
    }

    public static CoordinateSystem3D applyNormalizedOrientation(Object3D root, String className) {
        Object3DSet objects = Object3DTools.collectByClassName(root, className);
        CoordinateSystem3D cs = Object3DSetTools.computeNormalizedOrientation(objects);
        if (cs == null) {
            return null;
        }
        root.passiveTransform3(cs);
        return cs;
    }

    public static boolean isAncestor(Object3D ancestor, Object3D decendant) {
        if (ancestor == null) {
            return false;
        }
        if (decendant == null) {
            return false;
        }
        if (decendant.getParent() == null) {
            return false;
        }
        if (decendant.getParent() == ancestor) {
            return true;
        }
        return Object3DTools.isAncestor(ancestor, decendant.getParent());
    }

    public static Object3D findAncestor(Object3D node, List<? extends Object3D> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!Object3DTools.isAncestor(list.get(i), node)) continue;
            return list.get(i);
        }
        return null;
    }

    public static Object3D findAncestorOrEqual(Object3D node, List<? extends Object3D> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (node != list.get(i) && !Object3DTools.isAncestor(list.get(i), node)) continue;
            return list.get(i);
        }
        return null;
    }

    public static Object3D findAncestorByClassName(Object3D obj, String className) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() == null) {
            return null;
        }
        if (obj.getParent().getClassName().equals(className)) {
            return obj.getParent();
        }
        return Object3DTools.findAncestorByClassName(obj.getParent(), className);
    }

    public static boolean corridorCheck(Vector3D position, Vector3D direction, double corridorRadius, double corridorStart, Object3DSet atomSet) {
        for (int i = 0; i < atomSet.size(); ++i) {
            if (Object3DTools.corridorCheck(position, direction, corridorRadius, corridorStart, atomSet.get(i).getPosition())) continue;
            return false;
        }
        return true;
    }

    public static boolean corridorCheck(Vector3D position, Vector3D direction, double corridorRadius, double corridorStart, Vector3D atomPos) {
        Vector3D newDir = new Vector3D(direction);
        newDir.normalize();
        double proj = newDir.dot(atomPos.minus(position));
        if (proj < corridorStart) {
            return true;
        }
        double dist = Math.abs(GeometryTools.distanceToLine(atomPos, position, direction));
        return dist > corridorRadius;
    }

    public static double generateBoundingRadius(Object3D obj) {
        double dMax = 0.0;
        for (int i = 0; i < obj.size(); ++i) {
            double d = obj.getChild(i).getRelativePosition().length();
            if (!(d > dMax)) continue;
            dMax = d;
        }
        return dMax;
    }

    public static String generateChildNames(Object3D root) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < root.size(); ++i) {
            buf.append(root.getChild(i).getName() + " ");
        }
        return buf.toString();
    }

    public static String getProperty(Object3D obj, String key) {
        Properties properties = obj.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.getProperty(key);
    }

    public static void setProperty(Object3D obj, String key, String value) {
        Properties properties = obj.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(key, value);
        obj.setProperties(properties);
    }

    public static void setRecursiveProperty(Object3D obj, String key, String value, String className) {
        if (obj.getClassName().equals(className)) {
            Object3DTools.setProperty(obj, key, value);
        }
        for (int i = 0; i < obj.size(); ++i) {
            Object3DTools.setRecursiveProperty(obj.getChild(i), key, value, className);
        }
    }

    public static void setRecursiveProperty(Object3D obj, String key, String value) {
        Object3DTools.setProperty(obj, key, value);
        for (int i = 0; i < obj.size(); ++i) {
            Object3DTools.setRecursiveProperty(obj.getChild(i), key, value);
        }
    }

    public static Object3D findFirstLeaf(Object3D tree) {
        assert (tree != null);
        Object3D result = tree;
        while (result.size() > 0) {
            result = result.getChild(0);
        }
        return result;
    }

    public static String getFullName(Object3D obj) {
        if (obj.getParent() == null) {
            return obj.getName();
        }
        String name = obj.getName();
        Object3D curr = obj;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            name = curr.getName() + "." + name;
        }
        return name;
    }

    public static String getFullPrettyString(Object3D obj) {
        assert (false);
        String result = "";
        return result;
    }

    public static String getIndexName(Object3D obj) {
        return "" + (obj.getSiblingId() + 1);
    }

    public static String getFullIndexName(Object3D obj) {
        String name = Object3DTools.getIndexName(obj);
        Object3D curr = obj;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            name = Object3DTools.getIndexName(curr) + "." + name;
        }
        return name;
    }

    public static Object3D find(Object3D root, String name) {
        return Object3DNameCollector.find(root, name);
    }

    public static Object3D findRoot(Object3D objOrig) {
        Object3D obj = objOrig;
        while (obj.getParent() != null) {
            obj = obj.getParent();
        }
        return obj;
    }

    public static Object3D findByFullName(Object3D root, String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        Object3D current = root;
        String firstToken = tokenizer.nextToken();
        if (firstToken == null) {
            return null;
        }
        if (!firstToken.equals(root.getName()) && !firstToken.equals("1")) {
            return null;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 0) {
                return null;
            }
            if (token.charAt(0) == '(') {
                String[] subwords = token.split("\\)");
                if (subwords.length != 2) {
                    return null;
                }
                subwords[0] = subwords[0].substring(1);
                try {
                    int id = Integer.parseInt(subwords[1]) - 1;
                    String className = subwords[0];
                    if (className.equals("hxend")) {
                        className = "BranchDescriptor3D";
                    } else if (className.equals("helixend")) {
                        className = "BranchDescriptor3D";
                    } else if (className.equals("atom")) {
                        className = "Atom3D";
                    } else if (className.equals("strand")) {
                        className = "RnaStrand";
                    } else if (className.equals("residue")) {
                        className = "Nucleotide3D";
                    } else if (className.equals("stem")) {
                        className = "RnaStem3D";
                    }
                    int idx = current.getIndexOfChild(id, className);
                    if (idx < 0 || idx >= current.size()) {
                        return null;
                    }
                    current = current.getChild(idx);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    log.warning("Number format exception: " + nfe.getMessage());
                    return null;
                }
            }
            Object3D currentTmp = current.getChild(token);
            if (currentTmp == null) {
                if (token.equals("LAST")) {
                    if (current.size() == 0) {
                        log.warning("LAST operator not meaningful on object with zero child nodes: " + root.getFullName());
                        continue;
                    }
                    current = current.getChild(current.size() - 1);
                    continue;
                }
                try {
                    int id = Integer.parseInt(token) - 1;
                    if (id < 0 || id >= current.size()) {
                        return null;
                    }
                    current = current.getChild(id);
                    assert (current != null);
                    continue;
                }
                catch (NumberFormatException e) {
                    if (current != null) continue;
                    String childNames = "";
                    for (int i = 0; i < root.size(); ++i) {
                        childNames = childNames + root.getChild(i).getName() + " ";
                    }
                    log.warning("Could not find object with name " + name + " in " + root.getFullName() + " : " + childNames);
                    return null;
                }
            }
            current = currentTmp;
        }
        return current;
    }

    private static void addByClassName(Object3D root, String className, Object3DSet objectSet) {
        int i;
        if (debugMode) {
            for (int i2 = 0; i2 < objectSet.size(); ++i2) {
                assert (objectSet.get(i2).getClassName().equals(className));
            }
        }
        boolean found = false;
        if (root.getClassName().equals(className)) {
            found = true;
            objectSet.add(root);
        }
        if (!found || root.getClassName().equals("Object3D")) {
            for (i = 0; i < root.size(); ++i) {
                Object3DTools.addByClassName(root.getChild(i), className, objectSet);
            }
        }
        if (debugMode) {
            for (i = 0; i < objectSet.size(); ++i) {
                assert (objectSet.get(i).getClassName().equals(className));
            }
        }
    }

    private static int indexOf(String name, String[] words) {
        for (int i = 0; i < words.length; ++i) {
            if (!name.equals(words[i])) continue;
            return i;
        }
        return -1;
    }

    private static void addByClassName(Object3D root, String className, Object3DSet objectSet, String[] breakupNames) {
        if (Object3DTools.indexOf(root.getClassName(), breakupNames) >= 0) {
            return;
        }
        boolean found = false;
        if (root.getClassName().equals(className)) {
            found = true;
            objectSet.add(root);
        }
        if (!found || root.getClassName().equals("Object3D")) {
            for (int i = 0; i < root.size(); ++i) {
                Object3DTools.addByClassName(root.getChild(i), className, objectSet);
            }
        }
    }

    public static Object3DSet collectByClassName(Object3D root, String className) {
        assert (className != null);
        SimpleObject3DSet result = new SimpleObject3DSet();
        Object3DTools.addByClassName(root, className, result);
        if (debugMode) {
            for (int i = 0; i < result.size(); ++i) {
                assert (result.get(i).getClassName().equals(className));
            }
        }
        return result;
    }

    public static Object3DSet collectByClassName(Object3D root, String[] names, String className) {
        assert (className != null);
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (String s : names) {
            Object3D subTree = Object3DTools.findByFullName(root, s);
            if (subTree == null) continue;
            Object3DSet subset = Object3DTools.collectByClassName(subTree, className);
            result.merge(subset);
        }
        for (int i = 0; i < result.size(); ++i) {
            assert (result.get(i).getClassName().equals(className));
        }
        return result;
    }

    public static Object3D findClosestByClassName(Object3D root, Vector3D position, String className) {
        Object3DSet resultSet = Object3DTools.collectByClassName(root, className);
        assert (resultSet != null);
        if (resultSet.size() == 0) {
            return null;
        }
        return resultSet.get(Object3DSetTools.distanceMinId(position, resultSet));
    }

    private static Object3D findClosestLeaf(Object3D obj, Vector3D pos, Object3D sofarBest) {
        assert (obj != null);
        assert (pos != null);
        if (obj.size() == 0) {
            if (sofarBest == null) {
                assert (obj != null && obj.size() == 0);
                return obj;
            }
            double bestDist = sofarBest.getPosition().distance(pos);
            double dist = obj.getPosition().distance(pos);
            if (dist < bestDist) {
                assert (obj != null && obj.size() == 0);
                return obj;
            }
            assert (sofarBest != null && sofarBest.size() == 0);
            return sofarBest;
        }
        for (int i = 0; i < obj.size(); ++i) {
            sofarBest = Object3DTools.findClosestLeaf(obj.getChild(i), pos, sofarBest);
        }
        assert (sofarBest != null && sofarBest.size() == 0);
        return sofarBest;
    }

    public static Object3D findClosestLeaf(Object3D obj, Vector3D pos) {
        Object3D result = Object3DTools.findClosestLeaf(obj, pos, null);
        assert (result != null && result.size() == 0 && (obj == result || Object3DTools.isAncestor(obj, result)));
        return result;
    }

    public static Object3D findClosestLeafByClassName(Object3D root, Vector3D position, String className) {
        log.info("Started findClosestLeafByClassName!");
        if (root == null) {
            return null;
        }
        Object3DSet resultSet = Object3DTools.collectByClassName(root, className);
        int bestId = 0;
        double bestLeafDist = 1.0E30;
        for (int i = 0; i < resultSet.size(); ++i) {
            Object3D closestLeaf = Object3DTools.findClosestLeaf(resultSet.get(i), position);
            double leafDist = closestLeaf.getPosition().distance(position);
            if (!(leafDist < bestLeafDist)) continue;
            bestLeafDist = leafDist;
            bestId = i;
        }
        if (resultSet.size() == 0) {
            return null;
        }
        log.info("Finished findClosestLeafByClassName: " + position + " :" + resultSet.get(bestId).getFullName() + " : " + resultSet.get(bestId).getPosition());
        return resultSet.get(bestId);
    }

    public static Object3DSet collectByClassName(Object3D root, String className, String[] breakupNames) {
        assert (root != null);
        assert (className != null);
        assert (className.length() > 0);
        SimpleObject3DSet result = new SimpleObject3DSet();
        Object3DTools.addByClassName(root, className, result, breakupNames);
        assert (result != null);
        return result;
    }

    public static void randomizeOrientation(Object3D root) {
        Vector3D axis = Vector3DTools.generateRandomDirection();
        double angle = Math.PI * 2 * rnd.nextDouble();
        root.rotate(root.getPosition(), Matrix3D.rotationMatrix(axis, angle));
    }

    public static void randomizeTranslation(Object3D root, double scale) {
        Vector3D direction = Vector3DTools.generateRandomDirection();
        Random rnd = Randomizer.getInstance();
        double gauss = scale * Math.abs(rnd.nextGaussian());
        direction.scale(gauss);
        root.translate(direction);
    }

    public static void remove(Object3D obj) {
        Object3D parent = obj.getParent();
        if (parent != null) {
            parent.removeChild(obj);
        }
    }

    public static void printTree(PrintStream ps, Object3D root) {
        int i;
        int d = root.getDepth();
        for (i = 0; i < d; ++i) {
            ps.print(" ");
        }
        ps.println(root.getClassName() + " " + root.getName() + " " + Vector3DTools.prettyString(root.getPosition(), 7, 3) + " " + root.size());
        for (i = 0; i < root.size(); ++i) {
            Object3DTools.printTree(ps, root.getChild(i));
        }
    }

    public static String generateFullTreeLine(Object3D root) {
        if (root == null) {
            return "undefined";
        }
        return Object3DTools.getFullName(root) + " " + Object3DTools.getFullIndexName(root) + " " + root.size() + " " + root.getClassName() + " " + Vector3DTools.prettyString(root.getPosition(), 7, 3);
    }

    public static Vector<String> getFullNameTree(Object3D root, Set<String> allowedNames, Set<String> forbiddenNames) {
        Vector<String> result = new Vector<String>();
        if (Object3DTools.checkPrintable(root.getClassName(), allowedNames, forbiddenNames)) {
            result.add(Object3DTools.generateFullTreeLine(root));
        }
        if (forbiddenNames == null || !forbiddenNames.contains(root.getClassName())) {
            for (int i = 0; i < root.size(); ++i) {
                Vector<String> childResult = Object3DTools.getFullNameTree(root.getChild(i), allowedNames, forbiddenNames);
                for (String line : childResult) {
                    result.add(line);
                }
            }
        }
        return result;
    }

    public static void printFullNameTree(PrintStream ps, Object3D root, Set<String> allowedNames, Set<String> forbiddenNames) {
        String printTree = "";
        Vector<String> tree = Object3DTools.getFullNameTree(root, allowedNames, forbiddenNames);
        for (int i = 0; i < tree.size(); ++i) {
            ps.println(tree.get(i));
        }
    }

    private static boolean checkPrintable(String className, Set<String> allowedNames, Set<String> forbiddenNames) {
        if (className == null) {
            return false;
        }
        if (allowedNames != null && allowedNames.size() > 0 && !allowedNames.contains(className)) {
            return false;
        }
        return forbiddenNames == null || forbiddenNames.size() <= 0 || !forbiddenNames.contains(className);
    }

    public static void printFullNameTree(StringBuffer buf, Object3D root, Set<String> allowedNames, Set<String> forbiddenNames) {
        Vector<String> tree = Object3DTools.getFullNameTree(root, allowedNames, forbiddenNames);
        for (int i = 0; i < tree.size(); ++i) {
            buf.append(tree.get(i) + PackageConstants.NEWLINE);
        }
    }

    public static void printTree(StringBuffer buf, Object3D root) {
        int i;
        int d = root.getDepth();
        for (i = 0; i < d; ++i) {
            buf.append(" ");
        }
        buf.append(root.getClassName() + " " + root.getName() + " " + root.getPosition() + " " + root.size() + ENDL);
        for (i = 0; i < root.size(); ++i) {
            Object3DTools.printTree(buf, root.getChild(i));
        }
    }

    public static void removeByClassName(Object3D obj, String className) {
        if (obj.getClassName().equals(className)) {
            Object3DTools.remove(obj);
        } else {
            for (int i = obj.size() - 1; i >= 0; --i) {
                Object3D child = obj.getChild(i);
                if (child.getClassName().equals(className)) {
                    obj.removeChild(i);
                    continue;
                }
                Object3DTools.removeByClassName(child, className);
            }
        }
    }

    public static void setSelectAll(Object3D root, boolean choice) {
        Object3DActionVisitor.visitAll(root, new Object3DSetSelected(choice));
    }

    public static void stretch(Object3D obj, double scale) {
        obj.setRelativePosition(obj.getRelativePosition().mul(scale));
        for (int i = 0; i < obj.size(); ++i) {
            Object3DTools.stretch(obj.getChild(i), scale);
        }
    }

    public static void balanceTree(Object3D root) {
        if (root.size() == 0) {
            return;
        }
        if (root.getClassName().equals("BranchDescriptor3D") || root.getClassName().equals("StrandJunction3D") || root.getClassName().equals("KissingLoop3D") || root.getClassName().equals("CoordinateSystem3D")) {
            return;
        }
        for (int i = 0; i < root.size(); ++i) {
            Object3D child = root.getChild(i);
            Object3DTools.balanceTree(child);
        }
        Vector3D avg = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < root.size(); ++i) {
            Object3D child = root.getChild(i);
            avg.add(child.getPosition());
        }
        Vector3D testPos = root.getChild(0).getPosition();
        avg.scale(1.0 / (double)root.size());
        root.setIsolatedPosition(avg);
        Vector3D testPos2 = root.getChild(0).getPosition();
        assert (testPos.distance(testPos2) < 0.001);
    }

    public static void rotateSet(Object3DSet objectSet, Vector3D axis, Vector3D center, double angle) {
        for (int i = 0; i < objectSet.size(); ++i) {
            Object3D obj = objectSet.get(i);
            obj.setIsolatedPosition(Matrix3DTools.rotate(obj.getPosition(), axis, angle, center));
        }
    }
}

