/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.util.LinkedList;
import java.util.List;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DBugException;
import tools3d.objects3d.Object3DIterator;

public class Object3DDepthIterator
implements Object3DIterator {
    Object3D tree;
    int depthMax = -1;
    int depthMin = -1;
    List<Object3D> list = new LinkedList<Object3D>();

    public Object3DDepthIterator(Object3D t) {
        this.tree = t;
        this.list.add(t);
    }

    @Override
    public int getDepthMax() {
        return this.depthMax;
    }

    public int getDepthMin() {
        return this.depthMin;
    }

    @Override
    public void reset() {
        this.list.clear();
        this.list.add(this.tree);
    }

    @Override
    public boolean hasMoreObjects() {
        return this.list.size() > 0;
    }

    @Override
    public Object3D getNextObject() {
        int i;
        if (this.list.size() == 0) {
            return null;
        }
        Object3D result = null;
        do {
            result = this.list.get(0);
            this.list.remove(0);
            if (this.depthMin <= 0 || result.getDepth() >= this.depthMin) break;
            for (i = 0; i < result.size(); ++i) {
                this.list.add(result.getChild(i));
            }
        } while (this.list.size() > 0);
        if (result == null) {
            throw new Object3DBugException("Internal error in Object3DDepthIterator.getNextObject !");
        }
        if (this.depthMax < 0 || result.getDepth() < this.depthMax) {
            for (i = 0; i < result.size(); ++i) {
                this.list.add(result.getChild(i));
            }
        }
        return result;
    }

    @Override
    public void setDepthMax(int n) {
        this.depthMax = n;
    }

    public void setDepthMin(int n) {
        this.depthMin = n;
    }
}

