/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.util.logging.Logger;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DAction;
import tools3d.objects3d.Object3DEmptyVisitor;

public class Object3DActionVisitor
extends Object3DEmptyVisitor {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private Object3DAction action;
    private int verboseLevel = 0;

    public Object3DActionVisitor(Object3D o, Object3DAction _action) {
        super(o);
        this.action = _action;
    }

    @Override
    public Object next() {
        Object3D obj = (Object3D)super.next();
        if (obj == null) {
            log.warning("Warning: null in next command of Object3DActionVisitor!");
        }
        this.visit(obj);
        return obj;
    }

    @Override
    public void visit(Object3D o) {
        if (this.verboseLevel > 1) {
            log.fine("Object3DActionVisitor: visiting object " + o.getName());
        }
        this.action.act(o);
    }

    public void nextToEnd() {
        while (this.hasNext()) {
            this.next();
        }
    }

    public void setVerboseLevel(int n) {
        this.verboseLevel = n;
    }

    public static void visitAll(Object3D o, Object3DAction _action) {
        Object3DActionVisitor visitor = new Object3DActionVisitor(o, _action);
        visitor.nextToEnd();
    }
}

