/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DLinkSetBundleWriter;
import tools3d.objects3d.SimpleLinkSet;

public class GraphWriter
implements Object3DLinkSetBundleWriter {
    public static final String UNCOLORED_SYMBOL = "_";

    @Override
    public int getFormatId() {
        return 1;
    }

    @Override
    public String toString(Object3DLinkSetBundle bundle) {
        int i;
        StringBuffer buf = new StringBuffer();
        Object3D obj = bundle.getObject3D();
        buf.append("(graph3d " + obj.size() + " ");
        for (int i2 = 0; i2 < obj.size(); ++i2) {
            Vector3D pos = obj.getChild(i2).getPosition();
            String graphColor = obj.getChild(i2).getProperty("graph_color");
            if (graphColor == null || graphColor.equals("")) {
                graphColor = UNCOLORED_SYMBOL;
            }
            buf.append("" + (i2 + 1) + " " + graphColor + " " + pos.getX() + " " + pos.getY() + " " + pos.getZ() + "  ");
        }
        LinkSet links = bundle.getLinks();
        SimpleLinkSet newLinks = new SimpleLinkSet();
        for (i = 0; i < obj.size(); ++i) {
            for (int j = i; j < obj.size(); ++j) {
                Link link = links.find(obj.getChild(i), obj.getChild(j));
                if (link == null) continue;
                newLinks.add(link);
            }
        }
        buf.append(newLinks.size() + " ");
        for (i = 0; i < newLinks.size(); ++i) {
            Object3D obj1 = newLinks.get(i).getObj1();
            Object3D obj2 = newLinks.get(i).getObj2();
            buf.append(" " + (obj.getIndexOfChild(obj1) + 1) + " " + (obj.getIndexOfChild(obj2) + 1));
        }
        buf.append(" )");
        return buf.toString();
    }
}

