/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DOptimizer;
import tools3d.objects3d.Object3DPotential;

public class BrownianMotionOptimizer
implements Object3DOptimizer {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private int iterMax = 1000;
    private int verboseLevel = 1;
    private double transStep = 30.0;
    private double angleStep = 1.5707963267948966;
    private static Random rand = Randomizer.getInstance();

    private double generateRandomDouble(double min, double max) {
        assert (max >= min);
        double delta = max - min;
        double x = rand.nextDouble();
        x *= delta;
        return x += min;
    }

    private Vector3D generateRandomVector(double min, double max) {
        double x = this.generateRandomDouble(min, max);
        double y = this.generateRandomDouble(min, max);
        double z = this.generateRandomDouble(min, max);
        return new Vector3D(x, y, z);
    }

    public double getAngleStep() {
        return this.angleStep;
    }

    public double getTransStep() {
        return this.transStep;
    }

    @Override
    public double optimize(Object3D obj, Object3DPotential potential) {
        double bestScore = potential.computeValue(obj);
        if (this.verboseLevel > 0) {
            log.fine("Starting BrownianMotionOptimizer.optimize with score: " + bestScore + " and position: " + obj.getPosition());
        }
        for (int i = 0; i < this.iterMax; ++i) {
            double modStep = 0.99 * (1.0 - (double)i / (double)this.iterMax) + 0.01;
            double currTransStep = this.transStep * modStep;
            Vector3D trans = this.generateRandomVector(-currTransStep, currTransStep);
            Vector3D direction = this.generateRandomVector(0.0, 1.0);
            if (direction.length() == 0.0) {
                direction = new Vector3D(1.0, 0.0, 0.0);
            }
            direction.normalize();
            double currAngleStep = this.angleStep * modStep;
            double ang = this.generateRandomDouble(0.0, currAngleStep);
            obj.translate(trans);
            obj.rotate(direction, ang);
            double score = potential.computeValue(obj);
            if (score >= bestScore) {
                obj.rotate(direction, -ang);
                obj.translate(trans.mul(-1.0));
                continue;
            }
            bestScore = score;
            if (this.verboseLevel <= 0) continue;
            log.fine("Step " + (i + 1) + " New best score found: " + bestScore + " " + obj.getPosition());
        }
        if (this.verboseLevel > 0) {
            log.fine("Ending BrownianMotionOptimizer.optimize with score: " + bestScore + " and position: " + obj.getPosition());
        }
        return bestScore;
    }

    public void setTransStep(double transStep) {
        this.transStep = transStep;
    }

    public void setAngleStep(double angleStep) {
        this.angleStep = angleStep;
    }

    public void setIterMax(int iter) {
        this.iterMax = iter;
    }

    public void setVerboseLevel(int n) {
        this.verboseLevel = n;
    }
}

