/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import freeware.PrintfFormat;
import generaltools.Randomizer;
import java.util.Arrays;
import java.util.Random;
import numerictools.DoubleArrayTools;
import tools3d.Matrix3D;
import tools3d.Vector3D;
import tools3d.Vector4D;

public class Vector3DTools {
    public static final String HASH_DELIM = "_";
    private static Random rnd = Randomizer.getInstance();

    public static Vector3D generateCartesianFromPolar(double phi, double theta, double r) {
        return new Vector3D(r * Math.cos(phi) * Math.sin(theta), r * Math.sin(phi) * Math.sin(theta), r * Math.cos(theta));
    }

    public static Vector3D generateRandomDirection() {
        assert (rnd != null);
        double phi = Math.PI * 2 * rnd.nextDouble();
        double theta = Math.PI * rnd.nextDouble();
        Vector3D result = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
        assert (result.isValid());
        return result;
    }

    public static Vector3D generateOrthogonalDirection(Vector3D vOrig, Vector3D pOrig) {
        assert (vOrig.lengthSquare() > 0.0);
        assert (pOrig.lengthSquare() > 0.0);
        Vector3D v = new Vector3D(vOrig);
        Vector3D p = new Vector3D(pOrig);
        v.normalize();
        p.normalize();
        Vector3D result = p.minus(v.mul(p.dot(v)));
        assert (result.lengthSquare() > 0.0);
        result.normalize();
        assert (Math.abs(result.dot(vOrig)) < 0.01);
        return result;
    }

    public static Vector3D generateRandomOrthogonalDirection(Vector3D vOrig) {
        assert (vOrig.lengthSquare() > 0.0);
        Vector3D v = new Vector3D(vOrig);
        v.normalize();
        Vector3D p = null;
        while ((p = Vector3DTools.generateRandomDirection()).cross(v).lengthSquare() == 0.0) {
        }
        return Vector3DTools.generateOrthogonalDirection(v, p);
    }

    public static Vector3D[] generateSpherePoints(int n, double r, Vector3D origin) {
        int i;
        Vector3D[] ray = new Vector3D[n];
        if (n == 0) {
            return ray;
        }
        double oldPhi = 0.0;
        for (i = 1; i < n - 1; ++i) {
            ray[i] = new Vector3D();
            double h = -1.0 + 2.0 * (double)i / ((double)n - 1.0);
            double theta = Math.acos(h);
            double phi = oldPhi + 3.6 / Math.sqrt((double)n * (1.0 - h * h));
            ray[i].setX(Math.cos(phi) * Math.sin(theta));
            ray[i].setY(Math.sin(phi) * Math.sin(theta));
            ray[i].setZ(Math.cos(theta));
            oldPhi = phi;
        }
        ray[0] = new Vector3D(0.0, 0.0, -1.0);
        ray[n - 1] = new Vector3D(0.0, 0.0, 1.0);
        for (i = 0; i < ray.length; ++i) {
            ray[i].scale(r);
            ray[i].add(origin);
        }
        return ray;
    }

    public static double computeDrms(Vector3D[] v1, Vector3D[] v2) {
        double result = 0.0;
        double term = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            for (int j = i + 1; j < v1.length; ++j) {
                term = v1[i].minus(v1[j]).length() - v2[i].minus(v2[j]).length();
                result += term * term;
            }
        }
        double norm = 0.5 * (double)v1.length * (double)(v1.length - 1);
        result /= norm;
        result = Math.sqrt(result);
        return result;
    }

    public static double computeRms(Vector3D[] v1, Vector3D[] v2) {
        double result = 0.0;
        double term = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            result += v1[i].distanceSquare(v2[i]);
        }
        result /= (double)v1.length;
        result = Math.sqrt(result);
        return result;
    }

    public static Vector3D computeCenterGravity(Vector3D[] v) {
        assert (v.length > 0);
        Vector3D sum = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < v.length; ++i) {
            sum.add(v[i]);
        }
        sum.scale(1.0 / (double)v.length);
        return sum;
    }

    public static double[] computeVectorFieldSignature(Vector3D[] directions) {
        int n = directions.length;
        int n2 = n * (n - 1) / 2;
        double[] result = new double[n2];
        int pc = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                result[pc++] = directions[i].angle(directions[j]);
            }
        }
        Arrays.sort(result);
        assert (pc == result.length);
        return result;
    }

    public static double computeVectorFieldSimilarityScore(Vector3D[] directions1, Vector3D[] directions2) {
        assert (directions1.length > 1);
        assert (directions1.length == directions2.length);
        double[] sig1 = Vector3DTools.computeVectorFieldSignature(directions1);
        double[] sig2 = Vector3DTools.computeVectorFieldSignature(directions2);
        double maxDiff = Math.abs(sig1[0] - sig2[0]);
        for (int i = 1; i < sig1.length; ++i) {
            double diff = Math.abs(sig1[i] - sig2[i]);
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
        }
        assert (maxDiff >= 0.0);
        return maxDiff;
    }

    public static String prettyString(Vector3D vector, int len, int digits) {
        assert (digits >= 0);
        PrintfFormat positionFormat = new PrintfFormat("%" + len + "." + digits + "f");
        return "" + positionFormat.sprintf(vector.getX()) + " " + positionFormat.sprintf(vector.getY()) + " " + positionFormat.sprintf(vector.getZ());
    }

    private static void updateMomentOfInertiaMatrix(Matrix3D m, Vector3D v, double mass, Vector3D rotationCenter) {
        Vector3D d = v.minus(rotationCenter);
        double xx = mass * d.getX() * d.getX();
        double xy = mass * d.getX() * d.getY();
        double xz = mass * d.getX() * d.getZ();
        double yx = mass * d.getY() * d.getX();
        double yy = mass * d.getY() * d.getY();
        double yz = mass * d.getY() * d.getZ();
        double zx = mass * d.getZ() * d.getX();
        double zy = mass * d.getZ() * d.getY();
        double zz = mass * d.getZ() * d.getZ();
        m.setXX(m.getXX() + xx);
        m.setXY(m.getXY() + xy);
        m.setXZ(m.getXZ() + xz);
        m.setYX(m.getYX() + yx);
        m.setYY(m.getYY() + yy);
        m.setYZ(m.getYZ() + yz);
        m.setZX(m.getZX() + zx);
        m.setZY(m.getZY() + zy);
        m.setZZ(m.getZZ() + zz);
    }

    public static Matrix3D getMomentOfInertiaMatrix(Vector3D[] v, double[] masses, Vector3D rotationCenter) {
        assert (v.length == masses.length);
        Matrix3D result = new Matrix3D(0.0);
        for (int i = 0; i < v.length; ++i) {
            Vector3DTools.updateMomentOfInertiaMatrix(result, v[i], masses[i], rotationCenter);
        }
        return result;
    }

    public static Matrix3D getMomentOfInertiaMatrix(Vector3D[] v, double[] masses) {
        Vector3D rotationCenter = Vector3DTools.computeCenterGravity(v);
        return Vector3DTools.getMomentOfInertiaMatrix(v, masses, rotationCenter);
    }

    public static double[] getRadiiOfGyration(Vector3D[] v, double[] masses) {
        assert (v.length > 0);
        assert (v.length == masses.length);
        Matrix3D inertiaMatrix = Vector3DTools.getMomentOfInertiaMatrix(v, masses);
        Matrix matrix = new Matrix(inertiaMatrix.toArray());
        EigenvalueDecomposition decomp = new EigenvalueDecomposition(matrix);
        double[] eigenValues = decomp.getRealEigenvalues();
        assert (eigenValues.length == 3);
        double totalMass = DoubleArrayTools.computeSum(masses);
        assert (totalMass > 0.0);
        for (int i = 0; i < eigenValues.length; ++i) {
            eigenValues[i] = Math.sqrt(eigenValues[i] / totalMass);
        }
        Arrays.sort(eigenValues);
        double tmp = eigenValues[0];
        eigenValues[0] = eigenValues[2];
        eigenValues[2] = tmp;
        return eigenValues;
    }

    public static String computeEpsilonHash(double x, double epsilon) {
        return "" + Math.round(x / epsilon);
    }

    public static String computeEpsilonHash(Vector3D v, double epsilon) {
        return Vector3DTools.computeEpsilonHash(v.getX(), epsilon) + HASH_DELIM + Vector3DTools.computeEpsilonHash(v.getY(), epsilon) + HASH_DELIM + Vector3DTools.computeEpsilonHash(v.getZ(), epsilon);
    }

    public static String computeEpsilonHash(Vector4D v, double epsilon) {
        return Vector3DTools.computeEpsilonHash(v.getX(), epsilon) + HASH_DELIM + Vector3DTools.computeEpsilonHash(v.getY(), epsilon) + HASH_DELIM + Vector3DTools.computeEpsilonHash(v.getZ(), epsilon);
    }
}

