/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import graphtools.IntegerArrayGenerator;
import graphtools.IntegerPermutator;
import java.util.logging.Logger;
import tools3d.Orientable;
import tools3d.OrientableModifier;
import tools3d.Vector3D;

public class SystematicMutator
extends IntegerArrayGenerator
implements OrientableModifier,
IntegerPermutator {
    private static final int X_ID = 0;
    private static final int Y_ID = 1;
    private static final int Z_ID = 2;
    private static final int ANGLE_ID = 3;
    private static final int DEFAULT_SIZE = 4;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleStep;
    private Vector3D fixedAxis;
    private double translationStep;
    private Vector3D minPos;
    private boolean rotationFlag = false;

    public SystematicMutator() {
    }

    public SystematicMutator(double translationStep, Vector3D minPos, int[] maxNumbers, Vector3D axis) {
        super(maxNumbers);
        assert (maxNumbers.length == 4);
        this.translationStep = translationStep;
        assert (maxNumbers[3] > 0);
        assert (axis != null);
        this.angleStep = Math.PI * 2 / (double)maxNumbers[3];
        this.minPos = minPos;
        this.fixedAxis = new Vector3D(axis);
        assert (this.validate());
    }

    @Override
    public boolean validate() {
        return this.hasNext() && this.size() == 4 && this.fixedAxis != null && this.fixedAxis.length() > 0.0 && this.minPos != null;
    }

    public void copy(SystematicMutator other) {
        super.copy(other);
        this.angleStep = other.angleStep;
        this.fixedAxis = other.fixedAxis;
        this.translationStep = other.translationStep;
        this.minPos = other.minPos;
        this.rotationFlag = other.rotationFlag;
    }

    @Override
    public void rotate(Orientable obj) {
        assert (false);
    }

    @Override
    public double getAngleStep() {
        return this.angleStep;
    }

    @Override
    public double getTranslationStep() {
        return this.translationStep;
    }

    @Override
    public void setAngleStep(double d) {
        this.angleStep = d;
        assert (this.validate());
    }

    public void setFixedAxis(Vector3D axis) {
        assert (axis != null);
        this.fixedAxis = new Vector3D(axis);
    }

    @Override
    public void setTranslationStep(double d) {
        this.translationStep = d;
        assert (this.validate());
    }

    @Override
    public void mutate(Orientable obj) {
        int[] ids = this.getNumbers();
        if (this.rotationFlag) {
            obj.rotate(this.fixedAxis, (double)ids[3] * this.angleStep);
        }
        Vector3D pos = new Vector3D(this.minPos);
        pos.setX(pos.getX() + (double)ids[0] * this.translationStep);
        pos.setY(pos.getY() + (double)ids[1] * this.translationStep);
        pos.setZ(pos.getZ() + (double)ids[2] * this.translationStep);
        obj.setPosition(pos);
    }

    @Override
    public void reset() {
        super.reset();
        this.rotationFlag = false;
    }

    @Override
    public void scaleAngleStep(double scale) {
        this.angleStep *= scale;
    }

    @Override
    public void scaleTranslationStep(double scale) {
        this.translationStep *= scale;
    }

    @Override
    public void translate(Orientable obj) {
        assert (false);
    }

    @Override
    public String toString() {
        return "" + this.translationStep + " " + 57.29577951308232 * this.angleStep + " " + this.minPos.toString() + " " + super.toString();
    }

    @Override
    public boolean inc() {
        int nai = this.getNumbers()[3];
        boolean result = super.inc();
        this.rotationFlag = this.getNumbers()[3] != nai;
        return result;
    }
}

