/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.CoordinateSystem;
import tools3d.Matrix3D;
import tools3d.Orientable;
import tools3d.Positionable3D;
import tools3d.Vector3D;

public class SimpleOrientable
implements Orientable {
    private Vector3D position = new Vector3D(0.0, 0.0, 0.0);
    private double rotationAngle = 0.0;
    private Vector3D rotationAxis = new Vector3D(1.0, 0.0, 0.0);
    private double zBufValue = 0.0;

    @Override
    public void activeTransform(CoordinateSystem cs) {
        assert (false);
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        assert (false);
    }

    public Object clone() {
        SimpleOrientable newObj = new SimpleOrientable();
        newObj.setPosition((Vector3D)this.position.clone());
        newObj.setRotationAngle(this.rotationAngle);
        newObj.setRotationAxis((Vector3D)this.rotationAxis.clone());
        newObj.setZBufValue(this.zBufValue);
        return newObj;
    }

    @Override
    public Object cloneDeep() {
        return this.clone();
    }

    public void copyDeep(Orientable other) {
        this.setPosition((Vector3D)other.getPosition().clone());
        this.setRotationAngle(other.getRotationAngle());
        this.setRotationAxis((Vector3D)other.getRotationAxis().clone());
        this.setZBufValue(other.getZBufValue());
    }

    @Override
    public double distance(Positionable3D other) {
        return this.getPosition().minus(other.getPosition()).length();
    }

    @Override
    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public Vector3D getRotationAxis() {
        return this.rotationAxis;
    }

    @Override
    public double getRotationAngle() {
        return this.rotationAngle;
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    @Override
    public int compareTo(Positionable3D obj) {
        double oVal = obj.getZBufValue();
        if (this.zBufValue < oVal) {
            return -1;
        }
        if (this.zBufValue > oVal) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isValid() {
        return this.getPosition().isValid();
    }

    @Override
    public void setPosition(Vector3D point) {
        this.position = point;
    }

    @Override
    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
    }

    @Override
    public void setRotationAxis(Vector3D axis) {
        this.rotationAxis = axis;
    }

    @Override
    public void rotate(Vector3D axis, double angle) {
        assert (false);
    }

    @Override
    public void rotate(Vector3D center, Matrix3D matrix) {
        assert (false);
    }

    @Override
    public void rotate(Vector3D center, Vector3D axis, double angle) {
        assert (false);
    }

    @Override
    public void setZBufValue(double zBufValue) {
        this.zBufValue = zBufValue;
    }

    @Override
    public void translate(Vector3D vec) {
        this.position = this.position.plus(vec);
    }
}

