/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.awt.geom.Point2D;
import tools3d.Camera;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.Vector3D;

public class SimpleCamera
implements Camera {
    private int origin2DX = 0;
    private int origin2DY = 0;
    private Vector3D position;
    private Matrix3D orientation;
    private double zoom;

    public SimpleCamera() {
        this.position = new Vector3D(0.0, -10.0, 0.0);
        this.orientation = new Matrix3D(1.0);
        this.zoom = 1.0;
    }

    public SimpleCamera(Vector3D position, Matrix3D orientation, int origin2DX, int origin2DY) {
        this.origin2DX = origin2DX;
        this.origin2DY = origin2DY;
        this.position = position;
        this.orientation = orientation;
        this.zoom = 1.0;
    }

    @Override
    public void copy(Camera other) {
        if (other instanceof SimpleCamera) {
            SimpleCamera c = (SimpleCamera)other;
            this.origin2DX = c.origin2DX;
            this.origin2DY = c.origin2DY;
            this.position.copy(c.position);
            this.orientation.copy(c.orientation);
            this.zoom = c.zoom;
        }
    }

    @Override
    public Matrix3D getOrientation() {
        return this.orientation;
    }

    @Override
    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public Vector3D getViewDirection() {
        return this.orientation.getZRow();
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    @Override
    public Point2D project(Vector3D v) {
        double x = Matrix3DTools.project(v, this.orientation.getXRow(), this.position);
        double y = Matrix3DTools.project(v, this.orientation.getYRow(), this.position);
        x *= this.zoom;
        y *= this.zoom;
        return new Point2D.Double(x += (double)this.origin2DX, y += (double)this.origin2DY);
    }

    @Override
    public void setOrigin2D(int x, int y) {
        this.origin2DX = x;
        this.origin2DY = y;
    }

    @Override
    public void setPosition(Vector3D position) {
        this.position = position;
    }

    @Override
    public void setOrientation(Matrix3D m) {
        this.orientation = m;
    }

    @Override
    public void setZoom(double f) {
        this.zoom = f;
    }

    @Override
    public void translate(double x, double y) {
        double dx = this.orientation.getXX() * x + this.orientation.getYX() * y;
        double dy = this.orientation.getXY() * x + this.orientation.getYY() * y;
        double dz = this.orientation.getXZ() * x + this.orientation.getYZ() * y;
        this.position.setX(this.position.getX() + dx);
        this.position.setY(this.position.getY() + dy);
        this.position.setZ(this.position.getZ() + dz);
    }
}

