/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.logging.Logger;
import tools3d.Matrix3D;
import tools3d.Superpose;
import tools3d.SuperpositionResult;
import tools3d.SuperpositionTools;
import tools3d.Vector3D;

public class MinSuperpose
implements Superpose {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public boolean debugMode = true;
    public int NUMBER_STEPS_MAX = 1000;
    public int numTrials = 1;
    public int centerId = -1;

    private void arrayToVec3D(Vector3D v, double[] ary) {
        v.setX(ary[0]);
        v.setY(ary[1]);
        v.setZ(ary[2]);
    }

    void vec3DToArray(Vector3D v, double[] ary) {
        ary[0] = v.getX();
        ary[1] = v.getY();
        ary[2] = v.getZ();
    }

    private double atan(double x) {
        return Math.atan(x);
    }

    public double getNumTrials() {
        return this.numTrials;
    }

    private double sin(double x) {
        return Math.sin(x);
    }

    private double cos(double x) {
        return Math.cos(x);
    }

    public void setNumTrials(int n) {
        this.numTrials = n;
    }

    private double superpose(double[][] coords1, double[][] coords2, double[][] rot, double[] mc1, double[] mc2) {
        double gamma;
        double beta;
        double alpha;
        double val;
        int j;
        int i;
        int npoints;
        assert (coords1.length == coords2.length);
        assert (rot != null && rot.length == 3);
        assert (mc1 != null && mc1.length == 3);
        assert (mc2 != null && mc2.length == 3);
        if (this.debugMode) {
            // empty if block
        }
        if ((npoints = coords1.length) < 3) {
            assert (false);
            return 0.0;
        }
        double[][] mat_s = new double[3][3];
        double[][] mat_a = new double[3][3];
        double[][] mat_b = new double[3][3];
        double[][] mat_g = new double[3][3];
        double[][] mat_u = new double[3][3];
        double[][] tmp_mat = new double[3][3];
        int stepCounter = 0;
        double cz2 = 0.0;
        double cy2 = 0.0;
        double cx2 = 0.0;
        double cz1 = 0.0;
        double cy1 = 0.0;
        double cx1 = 0.0;
        for (i = 0; i < npoints; ++i) {
            cx1 += coords1[i][0];
            cy1 += coords1[i][1];
            cz1 += coords1[i][2];
            cx2 += coords2[i][0];
            cy2 += coords2[i][1];
            cz2 += coords2[i][2];
        }
        cx1 /= (double)npoints;
        cy1 /= (double)npoints;
        cz1 /= (double)npoints;
        cx2 /= (double)npoints;
        cy2 /= (double)npoints;
        cz2 /= (double)npoints;
        for (i = 0; i < npoints; ++i) {
            double[] dArray = coords1[i];
            dArray[0] = dArray[0] - cx1;
            double[] dArray2 = coords1[i];
            dArray2[1] = dArray2[1] - cy1;
            double[] dArray3 = coords1[i];
            dArray3[2] = dArray3[2] - cz1;
            double[] dArray4 = coords2[i];
            dArray4[0] = dArray4[0] - cx2;
            double[] dArray5 = coords2[i];
            dArray5[1] = dArray5[1] - cy2;
            double[] dArray6 = coords2[i];
            dArray6[2] = dArray6[2] - cz2;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                if (i == j) {
                    mat_g[i][j] = 1.0;
                    mat_b[i][j] = 1.0;
                    mat_a[i][j] = 1.0;
                    mat_s[i][j] = 1.0;
                } else {
                    mat_g[i][j] = 0.0;
                    mat_b[i][j] = 0.0;
                    mat_a[i][j] = 0.0;
                    mat_s[i][j] = 0.0;
                }
                mat_u[i][j] = 0.0;
            }
        }
        for (int n = 0; n < npoints; ++n) {
            double[] dArray = mat_u[0];
            dArray[0] = dArray[0] + coords1[n][0] * coords2[n][0];
            double[] dArray7 = mat_u[0];
            dArray7[1] = dArray7[1] + coords1[n][0] * coords2[n][1];
            double[] dArray8 = mat_u[0];
            dArray8[2] = dArray8[2] + coords1[n][0] * coords2[n][2];
            double[] dArray9 = mat_u[1];
            dArray9[0] = dArray9[0] + coords1[n][1] * coords2[n][0];
            double[] dArray10 = mat_u[1];
            dArray10[1] = dArray10[1] + coords1[n][1] * coords2[n][1];
            double[] dArray11 = mat_u[1];
            dArray11[2] = dArray11[2] + coords1[n][1] * coords2[n][2];
            double[] dArray12 = mat_u[2];
            dArray12[0] = dArray12[0] + coords1[n][2] * coords2[n][0];
            double[] dArray13 = mat_u[2];
            dArray13[1] = dArray13[1] + coords1[n][2] * coords2[n][1];
            double[] dArray14 = mat_u[2];
            dArray14[2] = dArray14[2] + coords1[n][2] * coords2[n][2];
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                tmp_mat[i][j] = 0.0;
            }
        }
        do {
            int k;
            double d = mat_u[2][1] - mat_u[1][2];
            double d2 = mat_u[1][1] + mat_u[2][2];
            alpha = d == 0.0 || d2 == 0.0 ? 0.0 : this.atan(d / d2);
            if (this.cos(alpha) * (mat_u[1][1] + mat_u[2][2]) + this.sin(alpha) * (mat_u[2][1] - mat_u[1][2]) < 0.0) {
                alpha += Math.PI;
            }
            double d3 = this.cos(alpha);
            mat_a[2][2] = d3;
            mat_a[1][1] = d3;
            mat_a[2][1] = this.sin(alpha);
            mat_a[1][2] = -mat_a[2][1];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_u[i][k] * mat_a[j][k];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_u[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_a[i][k] * mat_s[k][j];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_s[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            d = mat_u[0][2] - mat_u[2][0];
            d2 = mat_u[0][0] + mat_u[2][2];
            beta = d == 0.0 || d2 == 0.0 ? 0.0 : this.atan(d / d2);
            if (this.cos(beta) * (mat_u[0][0] + mat_u[2][2]) + this.sin(beta) * (mat_u[0][2] - mat_u[2][0]) < 0.0) {
                beta += Math.PI;
            }
            double d4 = this.cos(beta);
            mat_b[2][2] = d4;
            mat_b[0][0] = d4;
            mat_b[0][2] = this.sin(beta);
            mat_b[2][0] = -mat_b[0][2];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_u[i][k] * mat_b[j][k];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_u[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_b[i][k] * mat_s[k][j];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_s[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            d = mat_u[1][0] - mat_u[0][1];
            d2 = mat_u[0][0] + mat_u[1][1];
            gamma = d == 0.0 || d2 == 0.0 ? 0.0 : this.atan(d / d2);
            if (this.cos(gamma) * (mat_u[0][0] + mat_u[1][1]) + this.sin(gamma) * (mat_u[1][0] - mat_u[0][1]) < 0.0) {
                gamma += Math.PI;
            }
            double d5 = this.cos(gamma);
            mat_g[1][1] = d5;
            mat_g[0][0] = d5;
            mat_g[1][0] = this.sin(gamma);
            mat_g[0][1] = -mat_g[1][0];
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_u[i][k] * mat_g[j][k];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_u[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 3; ++k) {
                        double[] dArray = tmp_mat[i];
                        int n = j;
                        dArray[n] = dArray[n] + mat_g[i][k] * mat_s[k][j];
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    mat_s[i][j] = tmp_mat[i][j];
                    tmp_mat[i][j] = 0.0;
                }
            }
        } while ((val = Math.abs(alpha) + Math.abs(beta) + Math.abs(gamma)) > 1.0E-4 && stepCounter++ < this.NUMBER_STEPS_MAX);
        val = 0.0;
        for (i = 0; i < npoints; ++i) {
            double x = coords2[i][0];
            double y = coords2[i][1];
            double z = coords2[i][2];
            double tmpx = x * mat_s[0][0] + y * mat_s[0][1] + z * mat_s[0][2];
            double tmpy = x * mat_s[1][0] + y * mat_s[1][1] + z * mat_s[1][2];
            double tmpz = x * mat_s[2][0] + y * mat_s[2][1] + z * mat_s[2][2];
            x = coords1[i][0] - tmpx;
            y = coords1[i][1] - tmpy;
            z = coords1[i][2] - tmpz;
            val += x * x + y * y + z * z;
        }
        for (i = 0; i < npoints; ++i) {
            double[] dArray = coords1[i];
            dArray[0] = dArray[0] + cx1;
            double[] dArray15 = coords1[i];
            dArray15[1] = dArray15[1] + cy1;
            double[] dArray16 = coords1[i];
            dArray16[2] = dArray16[2] + cz1;
            double[] dArray17 = coords2[i];
            dArray17[0] = dArray17[0] + cx2;
            double[] dArray18 = coords2[i];
            dArray18[1] = dArray18[1] + cy2;
            double[] dArray19 = coords2[i];
            dArray19[2] = dArray19[2] + cz2;
        }
        if (rot != null) {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    rot[i][j] = mat_s[i][j];
                }
            }
        }
        if (mc1 != null) {
            mc1[0] = cx1;
            mc1[1] = cy1;
            mc1[2] = cz1;
        }
        if (mc2 != null) {
            mc2[0] = cx2;
            mc2[1] = cy2;
            mc2[2] = cz2;
        }
        if (this.debugMode) {
            // empty if block
        }
        return Math.sqrt(val / (double)npoints);
    }

    public SuperpositionResult superposeSingle(Vector3D[] v1, Vector3D[] v2) {
        int i;
        assert (v1.length > 2);
        assert (v1.length == v2.length);
        if (this.debugMode) {
            for (int i2 = 0; i2 < v1.length; ++i2) {
            }
        }
        Vector3D c1 = new Vector3D();
        Vector3D c2 = new Vector3D();
        int n = v1.length;
        double[][] v1Double = new double[n][3];
        double[][] v2Double = new double[n][3];
        double[][] rot = new double[3][3];
        double[] row0 = new double[3];
        double[] row1 = new double[3];
        double[] row2 = new double[3];
        rot[0] = row0;
        rot[1] = row1;
        rot[2] = row2;
        double[] mc1 = new double[3];
        double[] mc2 = new double[3];
        for (i = 0; i < 3; ++i) {
            mc1[i] = 0.0;
            mc2[i] = 0.0;
            for (int j = 0; j < 3; ++j) {
                rot[i][j] = 0.0;
            }
        }
        for (i = 0; i < v1.length; ++i) {
            this.vec3DToArray(v1[i], v1Double[i]);
            this.vec3DToArray(v2[i], v2Double[i]);
        }
        double resultDouble = this.superpose(v1Double, v2Double, rot, mc1, mc2);
        for (int i3 = 0; i3 < n; ++i3) {
            v2[i3].setX(v2Double[i3][0]);
            v2[i3].setY(v2Double[i3][1]);
            v2[i3].setZ(v2Double[i3][2]);
        }
        this.arrayToVec3D(c1, mc1);
        this.arrayToVec3D(c2, mc2);
        Matrix3D m = new Matrix3D(rot[0][0], rot[0][1], rot[0][2], rot[1][0], rot[1][1], rot[1][2], rot[2][0], rot[2][1], rot[2][2]);
        SuperpositionResult superposition = new SuperpositionResult();
        assert (m != null);
        superposition.setRotationMatrix(m);
        assert (v2 != null);
        superposition.setNewCoords(v2);
        assert (c1 != null);
        superposition.setShift1(c1);
        assert (c2 != null);
        superposition.setShift2(c2);
        superposition.setRms(resultDouble);
        assert (superposition.isValid());
        return superposition;
    }

    public SuperpositionResult superpose(Vector3D[] v1, Vector3D[] v2Orig, int numTrials) {
        int i;
        assert (false);
        assert (numTrials > 0);
        assert (v1.length > 2);
        assert (v1.length == v2Orig.length);
        int dim = v1.length;
        SuperpositionResult bestResult = null;
        double bestRms = 0.0;
        Matrix3D bestRandomMatrix = null;
        Vector3D[] v2 = new Vector3D[dim];
        Vector3D[] v2Best = new Vector3D[dim];
        for (i = 0; i < dim; ++i) {
            v2[i] = new Vector3D(v2Orig[i]);
            v2Best[i] = new Vector3D(v2Orig[i]);
        }
        for (i = 0; i < numTrials; ++i) {
            for (int j = 0; j < dim; ++j) {
                v2[j].copy(v2Orig[j]);
            }
            Matrix3D randMtx = SuperpositionTools.randomRotateAroundOrigin(v2);
            SuperpositionResult supResult = this.superposeSingle(v1, v2);
            double rms = supResult.getRms();
            if (i != 0 && !(rms < bestRms)) continue;
            if (i <= 0 || bestRms - rms > 0.1) {
                // empty if block
            }
            bestResult = supResult;
            bestRms = rms;
            bestRandomMatrix = randMtx;
            for (int j = 0; j < dim; ++j) {
                v2Best[j].copy(v2[j]);
            }
        }
        Matrix3D supMatrix = bestResult.getRotationMatrix();
        supMatrix = supMatrix.multiply(bestRandomMatrix);
        bestResult.setRotationMatrix(supMatrix);
        for (int i2 = 0; i2 < dim; ++i2) {
            v2Orig[i2].copy(v2Best[i2]);
        }
        return bestResult;
    }

    @Override
    public SuperpositionResult superpose(Vector3D[] v1, Vector3D[] v2) {
        int i;
        SuperpositionResult result = null;
        for (i = 0; i < v1.length; ++i) {
        }
        result = this.numTrials > 1 ? this.superpose(v1, v2, this.numTrials) : this.superposeSingle(v1, v2);
        for (i = 0; i < v1.length; ++i) {
            Vector3D v = new Vector3D(v2[i]);
            result.applyTransformation(v);
        }
        return result;
    }
}

