/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.io.Serializable;
import tools3d.Matrix4D;
import tools3d.Vector3D;

public class Matrix3D
implements Serializable {
    public static final String SPACE = " ";
    public static final String NEWLINE = System.getProperty("line.separator");
    Vector3D xRow;
    Vector3D yRow;
    Vector3D zRow;

    public Matrix3D() {
        this.setXRow(0.0, 0.0, 0.0);
        this.setYRow(0.0, 0.0, 0.0);
        this.setZRow(0.0, 0.0, 0.0);
    }

    public Matrix3D(double diagonal) {
        this.setXRow(diagonal, 0.0, 0.0);
        this.setYRow(0.0, diagonal, 0.0);
        this.setZRow(0.0, 0.0, diagonal);
    }

    public Matrix3D(Matrix4D m) {
        this(m.submatrix());
    }

    public Matrix3D(double diagX, double diagY, double diagZ) {
        this.setXRow(diagX, 0.0, 0.0);
        this.setYRow(0.0, diagY, 0.0);
        this.setZRow(0.0, 0.0, diagZ);
    }

    public Matrix3D(Vector3D newXRow, Vector3D newYRow, Vector3D newZRow) {
        this.setXRow(newXRow);
        this.setYRow(newYRow);
        this.setZRow(newZRow);
    }

    public Matrix3D(double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz) {
        this.setXRow(xx, xy, xz);
        this.setYRow(yx, yy, yz);
        this.setZRow(zx, zy, zz);
    }

    public Matrix3D(Matrix3D other) {
        this();
        this.copy(other);
    }

    public boolean equals(Matrix3D other) {
        return this.getXRow().equals(other.getXRow()) && this.getYRow().equals(other.getYRow()) && this.getZRow().equals(other.getZRow());
    }

    public boolean isRotation() {
        return Math.abs(this.determinant() - 1.0) < 0.01;
    }

    public Matrix3D multiply(double number) {
        Matrix3D result = new Matrix3D();
        result.getXRow().copy(this.getXRow().mul(number));
        result.getYRow().copy(this.getYRow().mul(number));
        result.getZRow().copy(this.getZRow().mul(number));
        return result;
    }

    public double determinant() {
        double[][] m = this.toArray();
        return m[0][0] * (m[1][1] * m[2][2] - m[1][2] * m[2][1]) - m[0][1] * (m[1][0] * m[2][2] - m[2][0] * m[1][2]) + m[0][2] * (m[1][0] * m[2][1] - m[2][0] * m[1][1]);
    }

    public void scale(double _scale) {
        this.xRow.scale(_scale);
        this.yRow.scale(_scale);
        this.zRow.scale(_scale);
    }

    public Vector3D multiply(Vector3D vect) {
        Vector3D result = new Vector3D();
        result.setX(this.getXX() * vect.getX() + this.getXY() * vect.getY() + this.getXZ() * vect.getZ());
        result.setY(this.getYX() * vect.getX() + this.getYY() * vect.getY() + this.getYZ() * vect.getZ());
        result.setZ(this.getZX() * vect.getX() + this.getZY() * vect.getY() + this.getZZ() * vect.getZ());
        return result;
    }

    public Matrix3D multiply(Matrix3D other) {
        Matrix3D result = new Matrix3D();
        result.setXX(this.getXX() * other.getXX() + this.getXY() * other.getYX() + this.getXZ() * other.getZX());
        result.setXY(this.getXX() * other.getXY() + this.getXY() * other.getYY() + this.getXZ() * other.getZY());
        result.setXZ(this.getXX() * other.getXZ() + this.getXY() * other.getYZ() + this.getXZ() * other.getZZ());
        result.setYX(this.getYX() * other.getXX() + this.getYY() * other.getYX() + this.getYZ() * other.getZX());
        result.setYY(this.getYX() * other.getXY() + this.getYY() * other.getYY() + this.getYZ() * other.getZY());
        result.setYZ(this.getYX() * other.getXZ() + this.getYY() * other.getYZ() + this.getYZ() * other.getZZ());
        result.setZX(this.getZX() * other.getXX() + this.getZY() * other.getYX() + this.getZZ() * other.getZX());
        result.setZY(this.getZX() * other.getXY() + this.getZY() * other.getYY() + this.getZZ() * other.getZY());
        result.setZZ(this.getZX() * other.getXZ() + this.getZY() * other.getYZ() + this.getZZ() * other.getZZ());
        return result;
    }

    public Matrix3D plus(Matrix3D other) {
        Matrix3D result = new Matrix3D();
        result.setXRow(this.getXRow().plus(other.getXRow()));
        result.setYRow(this.getYRow().plus(other.getYRow()));
        result.setZRow(this.getZRow().plus(other.getZRow()));
        return result;
    }

    public Matrix3D minus(Matrix3D other) {
        Matrix3D result = new Matrix3D();
        result.setXRow(this.getXRow().minus(other.getXRow()));
        result.setYRow(this.getYRow().minus(other.getYRow()));
        result.setZRow(this.getZRow().minus(other.getZRow()));
        return result;
    }

    public double norm() {
        double squareSum = this.getXRow().lengthSquare() + this.getYRow().lengthSquare() + this.getZRow().lengthSquare();
        return Math.sqrt(squareSum);
    }

    public Matrix3D add(Matrix3D other) {
        this.xRow.add(other.getXRow());
        this.yRow.add(other.getYRow());
        this.zRow.add(other.getZRow());
        return this;
    }

    public Matrix3D subtract(Matrix3D other) {
        this.xRow.sub(other.getXRow());
        this.yRow.sub(other.getYRow());
        this.zRow.sub(other.getZRow());
        return this;
    }

    double[][] toArray() {
        double[][] result = new double[3][3];
        result[0][0] = this.getXX();
        result[0][1] = this.getXY();
        result[0][2] = this.getXZ();
        result[1][0] = this.getYX();
        result[1][1] = this.getYY();
        result[1][2] = this.getYZ();
        result[2][0] = this.getZX();
        result[2][1] = this.getZY();
        result[2][2] = this.getZZ();
        return result;
    }

    public double trace() {
        return this.getXX() + this.getYY() + this.getZZ();
    }

    public Matrix3D transposed() {
        return new Matrix3D(this.getXX(), this.getYX(), this.getZX(), this.getXY(), this.getYY(), this.getZY(), this.getXZ(), this.getYZ(), this.getZZ());
    }

    public Vector3D getXRow() {
        return this.xRow;
    }

    public Vector3D getYRow() {
        return this.yRow;
    }

    public Vector3D getZRow() {
        return this.zRow;
    }

    public double getXX() {
        return this.getXRow().getX();
    }

    public double getXY() {
        return this.getXRow().getY();
    }

    public double getXZ() {
        return this.getXRow().getZ();
    }

    public double getYX() {
        return this.getYRow().getX();
    }

    public double getYY() {
        return this.getYRow().getY();
    }

    public double getYZ() {
        return this.getYRow().getZ();
    }

    public double getZX() {
        return this.getZRow().getX();
    }

    public double getZY() {
        return this.getZRow().getY();
    }

    public double getZZ() {
        return this.getZRow().getZ();
    }

    public void setXX(double xx) {
        this.xRow.setX(xx);
    }

    public void setXY(double xy) {
        this.xRow.setY(xy);
    }

    public void setXZ(double xz) {
        this.xRow.setZ(xz);
    }

    public void setYX(double yx) {
        this.yRow.setX(yx);
    }

    public void setYY(double yy) {
        this.yRow.setY(yy);
    }

    public void setYZ(double yz) {
        this.yRow.setZ(yz);
    }

    public void setZX(double zx) {
        this.zRow.setX(zx);
    }

    public void setZY(double zy) {
        this.zRow.setY(zy);
    }

    public void setZZ(double zz) {
        this.zRow.setZ(zz);
    }

    public String toString() {
        String result = "(Matrix3D " + NEWLINE + this.getXX() + SPACE + this.getXY() + SPACE + this.getXZ() + NEWLINE + this.getYX() + SPACE + this.getYY() + SPACE + this.getYZ() + NEWLINE + this.getZX() + SPACE + this.getZY() + SPACE + this.getZZ() + SPACE + ")" + SPACE;
        return result;
    }

    public static Matrix3D rotationMatrix(Vector3D vect, double alpha) {
        Matrix3D R = new Matrix3D(1.0);
        if (vect.lengthSquare() == 0.0 || alpha == 0.0) {
            return R;
        }
        vect.normalize();
        Vector3D vectSin = vect.mul(Math.sin(alpha));
        double xsin = vectSin.getX();
        double ysin = vectSin.getY();
        double zsin = vectSin.getZ();
        Matrix3D S = new Matrix3D(0.0, -zsin, ysin, zsin, 0.0, -xsin, -ysin, xsin, 0.0);
        double x = vect.getX();
        double y = vect.getY();
        double z = vect.getZ();
        Matrix3D U = new Matrix3D(x * x, x * y, x * z, y * x, y * y, y * z, z * x, z * y, z * z);
        R.subtract(U);
        R.scale(Math.cos(alpha));
        R.add(U);
        R.add(S);
        return R;
    }

    public void copy(Matrix3D other) {
        if (this.getXRow() == null) {
            this.setXRow(new Vector3D());
        }
        this.xRow.copy(other.getXRow());
        if (this.getYRow() == null) {
            this.setYRow(new Vector3D());
        }
        this.yRow.copy(other.getYRow());
        if (this.getZRow() == null) {
            this.setZRow(new Vector3D());
        }
        this.zRow.copy(other.getZRow());
    }

    public void copy(Vector3D newXRow, Vector3D newYRow, Vector3D newZRow) {
        this.xRow.copy(newXRow);
        this.yRow.copy(newYRow);
        this.zRow.copy(newZRow);
    }

    public void setXRow(Vector3D x) {
        this.xRow = x;
    }

    public void setXRow(double x, double y, double z) {
        this.setXRow(new Vector3D(x, y, z));
    }

    public void setYRow(Vector3D y) {
        this.yRow = y;
    }

    public void setYRow(double x, double y, double z) {
        this.setYRow(new Vector3D(x, y, z));
    }

    public void setZRow(Vector3D z) {
        this.zRow = z;
    }

    public void setZRow(double x, double y, double z) {
        this.setZRow(new Vector3D(x, y, z));
    }

    public void set(Vector3D x, Vector3D y, Vector3D z) {
        this.xRow = x;
        this.yRow = y;
        this.zRow = z;
    }

    public static Matrix3D outerProduct(Vector3D a, Vector3D b) {
        double xx = a.getX() * b.getX();
        double xy = a.getX() * b.getY();
        double xz = a.getX() * b.getZ();
        double yx = a.getY() * b.getX();
        double yy = a.getY() * b.getY();
        double yz = a.getY() * b.getZ();
        double zx = a.getZ() * b.getX();
        double zy = a.getZ() * b.getY();
        double zz = a.getZ() * b.getZ();
        return new Matrix3D(xx, xy, xz, yx, yy, yz, zx, zy, zz);
    }
}

