/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.awt.geom.Point2D;
import tools3d.SpaceToPlaneProjection;
import tools3d.Vector3D;

public class LinearProjection
implements SpaceToPlaneProjection {
    double a11 = 1.0;
    double a12 = 0.0;
    double a13 = 0.0;
    double a21 = 0.0;
    double a22 = 1.0;
    double a23 = 0.0;
    double b1 = 0.0;
    double b2 = 0.0;

    LinearProjection() {
    }

    @Override
    public Point2D project(Vector3D v) {
        double x = this.a11 * v.getX() + this.a12 * v.getY() + this.a13 * v.getZ() + this.b1;
        double y = this.a21 * v.getX() + this.a22 * v.getY() + this.a23 * v.getZ() + this.b2;
        return new Point2D.Double(x, y);
    }

    public void setXYDimensions(double x3DMin, double x3DMax, double y3DMin, double y3DMax, double x2DMin, double x2DMax, double y2DMin, double y2DMax) {
        this.a11 = (x2DMax - x2DMin) / (x3DMax - x3DMin);
        this.a12 = 0.0;
        this.a13 = 0.0;
        this.a21 = 0.0;
        this.a22 = (y2DMax - y2DMin) / (y3DMax - y3DMin);
        this.a23 = 0.0;
        this.b1 = x2DMin - this.a11 * x3DMin;
        this.b2 = y2DMin - this.a22 * y3DMin;
    }

    public void setXZDimensions(double x3DMin, double x3DMax, double z3DMin, double z3DMax, double x2DMin, double x2DMax, double y2DMin, double y2DMax) {
        this.a11 = (x2DMax - x2DMin) / (x3DMax - x3DMin);
        this.a12 = 0.0;
        this.a13 = 0.0;
        this.a21 = 0.0;
        this.a22 = 0.0;
        this.a23 = (y2DMax - y2DMin) / (z3DMax - z3DMin);
        this.b1 = x2DMin - this.a11 * x3DMin;
        this.b2 = y2DMin - this.a22 * z3DMin;
    }

    public void moveCameraNorth(double v) {
        this.b1 += v;
    }

    public void moveCameraWest(double v) {
        this.b2 += v;
    }

    public void moveCameraEast(double v) {
        this.b2 -= v;
    }

    public void moveCameraSouth(double v) {
        this.b1 -= v;
    }

    public void rotateCameraNorth(double angle) {
    }

    public void rotateCameraWest(double angle) {
    }

    public void rotateCameraEast(double angle) {
    }

    public void rotateCameraSouth(double angle) {
    }

    public void zoom(double factor) {
        this.a11 *= factor;
        this.a12 *= factor;
        this.a13 *= factor;
        this.a21 *= factor;
        this.a22 *= factor;
        this.a23 *= factor;
    }
}

