/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.AbstractGeometryElement;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;

public class Face3D
extends AbstractGeometryElement {
    private Vector3D normal;
    private Vector3D[] points;

    public Face3D(Vector3D[] points) {
        assert (points != null);
        this.points = points;
        this.updatePositionAndNormal();
    }

    @Override
    public void activeTransform(CoordinateSystem cs) {
        super.activeTransform(cs);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = cs.activeTransform(this.points[i]);
        }
    }

    private void updatePositionAndNormal() {
        Vector3D pos = new Vector3D(0.0, 0.0, 0.0);
        for (int i = 0; i < this.points.length; ++i) {
            pos.add(this.points[i]);
        }
        pos.scale(1.0 / (double)this.points.length);
        this.setPosition(pos);
        if (this.points.length >= 3) {
            this.normal = this.points[1].minus(this.points[0]).cross(this.points[2].minus(this.points[0]));
            if (this.normal.length() > 0.0) {
                this.normal.normalize();
            }
        }
    }

    public Face3D(Face3D other) {
        this(other.getPoints());
    }

    @Override
    public Object cloneDeep() {
        Vector3D[] newPoints = new Vector3D[this.points.length];
        for (int i = 0; i < newPoints.length; ++i) {
            newPoints[i] = new Vector3D(this.points[i]);
        }
        return new Face3D(newPoints);
    }

    public Vector3D getPoint(int n) {
        return this.points[n];
    }

    public Vector3D[] getPoints() {
        return this.points;
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public int size() {
        return this.points.length;
    }

    @Override
    public void translate(Vector3D v) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].add(v);
        }
        this.position.add(v);
    }
}

