/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Matrix3D;
import tools3d.Vector4D;

public class CollisionDetectionTools {
    public static final Vector4D X_AXIS = new Vector4D(1.0, 0.0, 0.0, 0.0);
    public static final Vector4D Y_AXIS = new Vector4D(0.0, 1.0, 0.0, 0.0);
    public static final Vector4D Z_AXIS = new Vector4D(0.0, 0.0, 1.0, 0.0);

    public static Vector4D linePlaneIntersection(Vector4D line, Vector4D lineOffset, Vector4D planeU, Vector4D planeV, Vector4D planePoint) {
        Vector4D normal = planeU.cross(planeV);
        normal.normalize();
        double d = -1.0 * normal.dot(planePoint);
        return CollisionDetectionTools.linePlaneIntersection(line, lineOffset, normal, d);
    }

    public static Vector4D linePlaneIntersection(Vector4D v, Vector4D o, Vector4D n, double d) {
        double bottom = n.dot(v);
        double top = -1.0 * (d + n.dot(o));
        if (Math.abs(bottom) < 1.0E-9) {
            if (Math.abs(top) < 1.0E-10) {
                return v;
            }
            return null;
        }
        double t = top / bottom;
        Vector4D ret = v.mul(t);
        ret.add(o);
        return ret;
    }

    public static double linePlaneIntersectionValue(Vector4D v, Vector4D o, Vector4D n, double d) {
        double bottom = n.dot(v);
        double top = -1.0 * (d + n.dot(o));
        if (Math.abs(bottom) < 1.0E-10) {
            if (Math.abs(top) < 1.0E-10) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        double t = top / bottom;
        return t;
    }

    public static Vector4D intersecton3Planes(Vector4D n1, Vector4D p1, Vector4D n2, Vector4D p2, Vector4D n3, Vector4D p3) {
        Matrix3D matrix = new Matrix3D(n1.getX(), n1.getY(), n1.getZ(), n2.getX(), n2.getY(), n2.getZ(), n3.getX(), n3.getY(), n3.getZ());
        double determinant = matrix.determinant();
        if (determinant == 0.0) {
            return null;
        }
        Vector4D c1 = n2.cross(n3).mul(p1.dot(n1));
        Vector4D c2 = n3.cross(n1).mul(p2.dot(n2));
        Vector4D c3 = n1.cross(n2).mul(p3.dot(n3));
        Vector4D p = c1.plus(c2).plus(c3);
        p = p.mul(1.0 / determinant);
        return p;
    }
}

