/*
 * Decompiled with CFR 0.152.
 */
package statisticstools;

import generaltools.ParsingException;
import generaltools.Randomizer;
import generaltools.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import launchtools.SimpleQueueManager;
import statisticstools.AbstractScraper;
import statisticstools.BindewaldScraper;
import statisticstools.RSpearmanScraper;
import statisticstools.SimpleStatisticsResult;
import statisticstools.StatisticsResult;

public class CorrelationTests {
    public static final StatisticsResult DUMMY_CORRELATION = CorrelationTests.generateDummyCorrelation();
    public static boolean NDEBUG = true;
    private static String BIN_DIR = System.getenv("NANOTILER_HOME");
    private static SimpleQueueManager qm = SimpleQueueManager.getInstance();

    public static StatisticsResult generateDummyCorrelation() {
        SimpleStatisticsResult result = new SimpleStatisticsResult();
        result.setProperty("estimate", "0.0");
        result.setProperty("estimate_method", "dummy");
        return result;
    }

    private static List<Double> parsePairedDataLine(String line) throws ParsingException {
        assert (line != null);
        String[] words = (line = line.trim()).split(" ");
        if (words.length != 2) {
            throw new ParsingException("Two words expected in paired data line: " + line);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        try {
            result.add(new Double(Double.parseDouble(words[0])));
            result.add(new Double(Double.parseDouble(words[1])));
        }
        catch (NumberFormatException nfe) {
            throw new ParsingException("Bad number format in paired data line: " + line);
        }
        return result;
    }

    public static List<List<Double>> readPairedData(InputStream is) throws IOException, ParsingException {
        ArrayList<List<Double>> data = new ArrayList<List<Double>>();
        String[] lines = StringTools.readAllLines(is);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line == null || line.length() <= 0 || line.charAt(0) == '#') continue;
            data.add(CorrelationTests.parsePairedDataLine(line));
        }
        return data;
    }

    private static void writeData(OutputStream os, List<List<Double>> data) throws IOException {
        PrintStream ps = new PrintStream(os);
        for (int i = 0; i < data.size(); ++i) {
            for (int j = 0; j < data.get(i).size(); ++j) {
                ps.print("" + data.get(i).get(j));
                if (j < data.get(i).size() - 1) {
                    ps.print(" ");
                    continue;
                }
                ps.println("");
            }
        }
    }

    public static StatisticsResult computeCorrelation(List<List<Double>> data, String method) {
        File tmpFile;
        if ("dummy".equals(method)) {
            return DUMMY_CORRELATION;
        }
        String fileName = "";
        try {
            tmpFile = File.createTempFile("corr", ".dat");
            if (NDEBUG) {
                tmpFile.deleteOnExit();
            }
            fileName = tmpFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            CorrelationTests.writeData(fos, data);
            fos.close();
        }
        catch (IOException ioe) {
            Properties properties = new Properties();
            properties.setProperty("success", "false");
            properties.setProperty("error_message", "IOException while writing data: " + ioe.getMessage());
            return new SimpleStatisticsResult(properties);
        }
        String command = BIN_DIR + "/correlation.sh " + fileName;
        if (method != null) {
            command = method.equals("bindewald") ? BIN_DIR + "/bindewald.pl " + fileName : command + " " + method;
        }
        List<String> lines = SimpleQueueManager.shell(command);
        assert (lines != null);
        if (NDEBUG && tmpFile != null) {
            tmpFile.delete();
        }
        StatisticsResult statResult = CorrelationTests.interpretCorrelationOutput(lines, method);
        return statResult;
    }

    public static StatisticsResult computeCorrelation(double[] v1, double[] v2, String method) {
        assert (v1.length == v2.length);
        ArrayList<List<Double>> list = new ArrayList<List<Double>>();
        for (int i = 0; i < v1.length; ++i) {
            ArrayList<Double> row = new ArrayList<Double>();
            row.add(new Double(v1[i]));
            row.add(new Double(v2[i]));
            list.add(row);
        }
        return CorrelationTests.computeCorrelation(list, method);
    }

    public static StatisticsResult interpretCorrelationOutput(List<String> lines, String method) {
        assert (lines != null);
        if (method == null) {
            Random rnd = Randomizer.getInstance();
            Properties properties = new Properties();
            properties.setProperty("success", "true");
            properties.setProperty("p-value", "" + 0.1 * rnd.nextDouble());
            properties.setProperty("correlation-coeff", "" + 0.1 * rnd.nextDouble());
            return new SimpleStatisticsResult(properties);
        }
        AbstractScraper scraper = null;
        if (method.equals("spearman")) {
            scraper = new RSpearmanScraper(lines);
        } else if (method.equals("bindewald")) {
            scraper = new BindewaldScraper(lines);
        } else {
            System.err.println("Unknown correlation method: " + method);
            throw new RuntimeException("Unknown correlation method: " + method);
        }
        assert (scraper != null);
        return scraper;
    }
}

