/*
 * Decompiled with CFR 0.152.
 */
package statisticstools;

import generaltools.StringTools;
import java.util.List;
import statisticstools.AbstractScraper;

public class BindewaldScraper
extends AbstractScraper {
    public BindewaldScraper(List<String> lines) {
        super(lines);
        this.parse();
        this.setName("bindewald");
    }

    public BindewaldScraper(String[] linesOrig) {
        this(StringTools.convertArrayToList(linesOrig));
    }

    @Override
    protected void parse() {
        assert (this.lines != null);
        for (int i = 0; i < this.lines.size(); ++i) {
            String[] words = ((String)this.lines.get(i)).split(" ");
            if (words.length != 6 || !words[3].equals("p-value")) continue;
            try {
                this.setPValue(Double.parseDouble(words[5]));
                this.errorMessage = "";
                break;
            }
            catch (NumberFormatException nfe) {
                this.errorMessage = nfe.getMessage();
                assert (this.errorMessage != null && this.errorMessage.length() > 0);
                break;
            }
        }
    }
}

