/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import sequence.Alphabet;
import sequence.MutableSequence;
import sequence.Residue;
import sequence.Sequence;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;

public class SimpleMutableSequence
extends SimpleSequence
implements MutableSequence {
    public SimpleMutableSequence(String s, String name, Alphabet alphabet) throws UnknownSymbolException {
        super(s, name, alphabet);
    }

    public SimpleMutableSequence(Sequence s) throws UnknownSymbolException {
        super(s.sequenceString(), s.getName(), s.getAlphabet());
    }

    @Override
    public void removeResidue(int pos) {
        Residue res = this.getSequence().remove(pos);
        for (int i = pos; i < this.getSequence().size(); ++i) {
            Residue r = this.getSequence().get(i);
            r.setPos(r.getPos() - 1);
        }
    }

    @Override
    public void insertResidue(Residue residue, int position) {
        this.getSequence().add(position, residue);
        residue.setParentObject(this);
        for (int i = position + 1; i < this.getSequence().size(); ++i) {
            Residue r = this.getSequence().get(i);
            r.setPos(r.getPos() + 1);
        }
    }

    @Override
    public void mutateResidue(Residue residue, int position) {
        this.getSequence().set(position, residue);
    }
}

