/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.PropertyTools;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Properties;
import java.util.logging.Logger;
import rnasecondary.ImprovedSecondaryStructureParser;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.MonteCarloSequenceOptimizerVersionsFactory;
import secondarystructuredesign.PackageConstants;
import secondarystructuredesign.SequenceOptimizer;
import secondarystructuredesign.mcsopt;

public class mcseval
extends mcsopt {
    private static Logger log = Logger.getLogger("mcsopt");
    private static int debugLevel = 1;
    private static int configId = 2;

    private static void helpOutput(PrintStream ps) {
        ps.println("Evaluate compatibility of sequence with a secondary structure. Usage: mcseval filename\n");
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            mcseval.helpOutput(System.out);
            System.exit(0);
        }
        String fileName = args[0];
        String altFileName = null;
        if (args.length > 1) {
            altFileName = args[1];
        }
        MutableSecondaryStructure secStruct = null;
        MutableSecondaryStructure secStruct2 = null;
        log.info("Importing secondary structure from " + fileName);
        try {
            ImprovedSecondaryStructureParser parser = new ImprovedSecondaryStructureParser();
            secStruct = parser.parse(fileName);
            if (altFileName != null) {
                secStruct2 = parser.parse(altFileName);
            }
        }
        catch (IOException ioe) {
            log.warning("IO error when scraping result file from: " + fileName);
            mcseval.exitError(ioe.getMessage());
        }
        catch (ParseException pe) {
            log.warning("Parsing error when scraping result file from: " + fileName);
            mcseval.exitError(pe.getMessage());
        }
        if (secStruct == null) {
            mcseval.exitError("Error parsing secondary structure!");
        } else {
            log.info("Secondary structure correctly read!");
        }
        SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
        String resultString = writer.writeString(secStruct);
        System.out.println("Initial structure before optimization: " + PackageConstants.NEWLINE + resultString);
        mcseval.prettyPrint(System.out, secStruct);
        MonteCarloSequenceOptimizerVersionsFactory optimizerFactory = new MonteCarloSequenceOptimizerVersionsFactory(configId);
        SequenceOptimizer optimizer = optimizerFactory.generate();
        Properties properties = optimizer.eval(secStruct);
        PropertyTools.printProperties(System.out, properties);
        System.out.println("# Good bye!");
    }
}

