/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.ParsingException;
import generaltools.StringTools;
import graphtools.IntegerArrayGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import numerictools.AccuracyTools;
import numerictools.IntegerArrayTools;
import numerictools.IntervalInt;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.PackageConstants;
import secondarystructuredesign.RnaFoldTools;
import secondarystructuredesign.SecondaryStructureScorer;

public class RiboswitchSecondaryStructureScorer
implements SecondaryStructureScorer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");
    private static String binDir = PackageConstants.NANOTILER_HOME + PackageConstants.SLASH + "bin";
    private static String rnacofoldScriptName = binDir + PackageConstants.SLASH + rb.getString("rnacofoldscript");
    private static String rnacofoldPScriptName = binDir + PackageConstants.SLASH + rb.getString("rnacofoldpscript");
    private static String rnaFoldScriptName = binDir + PackageConstants.SLASH + rb.getString("rnafoldscript");
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private boolean probabilityMode = true;
    private double trueProbWeight = 1.0;
    private double falseProbWeight = 1.0;
    private String linkerSequence = "&";
    private String linkerSequence2 = "UUUUU";
    public static char UNKNOWN_INTERACTION_CHAR = (char)63;

    public String getLinkerSequence() {
        return this.linkerSequence;
    }

    public void setLinkerSequence(String s) {
        this.linkerSequence = s;
    }

    public void setProbabilityMode(boolean mode) {
        this.probabilityMode = mode;
    }

    public double interactionEnergy(char c1, char c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return 0.0;
        }
        if (c1 > c2) {
            return this.interactionEnergy(c2, c1);
        }
        switch (c1) {
            case 'A': {
                if (c2 == 'U') {
                    return this.energyAU;
                }
            }
            case 'C': {
                if (c2 != 'G') break;
                return this.energyGC;
            }
        }
        return 0.0;
    }

    String[] launchRnacofold(String sequence) throws IOException {
        File tmpInputFile = File.createTempFile("nanotiler_rnacofold", ".sec");
        tmpInputFile.deleteOnExit();
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
        this.log.fine("Writing to file: " + inputFileName);
        this.log.fine("Writing content: " + sequence);
        ps.println(sequence);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_rnacofold", ".seq");
        tmpOutputFile.deleteOnExit();
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        String[] commandWords = new String[]{rnacofoldScriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.fine("queue manager finished job!");
        this.log.fine("Importing optimized sequences from " + outputFileName);
        String[] resultLines = null;
        try {
            FileInputStream resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            throw ioe;
        }
        finally {
            if (tmpInputFile.exists()) {
                tmpInputFile.delete();
            }
            if (tmpOutputFile.exists()) {
                tmpOutputFile.delete();
            }
        }
        return resultLines;
    }

    private double scoreProbabilityMatrix(double[][] probMatrix, int[][] interactions) {
        assert (probMatrix != null && probMatrix[0] != null);
        assert (interactions != null && interactions[0] != null);
        assert (probMatrix.length == interactions.length);
        assert (probMatrix[0].length == interactions[0].length);
        double score = 0.0;
        for (int i = 0; i < interactions.length; ++i) {
            for (int j = i + 1; j < interactions[i].length; ++j) {
                if (interactions[i][j] == 1) {
                    score += this.trueProbWeight * (1.0 - probMatrix[i][j]);
                    continue;
                }
                if (interactions[i][j] != -1) continue;
                score += this.falseProbWeight * probMatrix[i][j];
            }
        }
        return score;
    }

    private double[][] launchRnacofoldProb(String sequence) throws IOException {
        assert (this.probabilityMode);
        File tmpInputFile = File.createTempFile("nanotiler_rnacofold", ".sec");
        tmpInputFile.deleteOnExit();
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
        this.log.fine("Writing to file: " + inputFileName);
        this.log.fine("Writing content: " + sequence);
        ps.println(sequence);
        fos.close();
        File tmpOutputFile = null;
        tmpOutputFile = this.probabilityMode ? File.createTempFile("nanotiler_rnacofold", ".ps") : File.createTempFile("nanotiler_rnacofold", ".seq");
        tmpOutputFile.deleteOnExit();
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        String[] commandWords = new String[]{rnacofoldPScriptName, inputFileName, outputFileName};
        this.log.fine("Launching command: " + StringTools.paste(commandWords, " "));
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.fine("queue manager finished job!");
        this.log.fine("Importing optimized sequences from " + outputFileName);
        String[] resultLines = null;
        FileInputStream resultFile = null;
        try {
            resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            throw ioe;
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
            }
            if (tmpInputFile.exists()) {
                tmpInputFile.delete();
            }
            if (tmpOutputFile.exists()) {
                tmpOutputFile.delete();
            }
        }
        double[][] result = null;
        try {
            result = RnaFoldTools.parseRnafoldProbabilities(resultLines);
        }
        catch (ParsingException pe) {
            throw new IOException("Parsing exception in parsing RNAcofold result postscript file: " + pe.getMessage());
        }
        finally {
            if (tmpOutputFile.exists()) {
                assert (false);
                tmpOutputFile.delete();
            }
        }
        return result;
    }

    String[] launchRnafold(String sequence) throws IOException {
        File tmpInputFile = File.createTempFile("nanotiler_rnafold", ".sec");
        tmpInputFile.deleteOnExit();
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
        this.log.fine("Writing to file: " + inputFileName);
        this.log.fine("Writing content: " + sequence);
        ps.println(sequence);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_rnafold", ".seq");
        tmpOutputFile.deleteOnExit();
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        File tempFile = new File(rnaFoldScriptName);
        String[] commandWords = new String[]{rnaFoldScriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.fine("queue manager finished job!");
        this.log.fine("Importing optimized sequences from " + outputFileName);
        String[] resultLines = null;
        FileInputStream resultFile = null;
        try {
            resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            throw ioe;
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
            }
            if (tmpOutputFile.exists()) {
                tmpOutputFile.delete();
            }
            if (tmpInputFile.exists()) {
                tmpInputFile.delete();
            }
        }
        return resultLines;
    }

    private double computeMatrixMatthews(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            block6: for (int j = i + 1; j < trueInteractions[0].length; ++j) {
                int pv = predictedInteractions[i][j];
                int tv = trueInteractions[i][j];
                switch (tv) {
                    case 1: {
                        if (pv == 1) {
                            ++tp;
                            continue block6;
                        }
                        ++fn;
                        continue block6;
                    }
                    case -1: {
                        if (pv == 1) {
                            ++fp;
                            continue block6;
                        }
                        ++tn;
                        continue block6;
                    }
                    case 0: {
                        continue block6;
                    }
                    default: {
                        assert (false);
                        continue block6;
                    }
                }
            }
        }
        return AccuracyTools.computeMatthews(tp, fp, tn, fn);
    }

    private double computeMatrixDifference(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int count = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            for (int j = 0; j < trueInteractions[0].length; ++j) {
                if (trueInteractions[i][j] == 0 || trueInteractions[i][j] == predictedInteractions[i][j]) continue;
                ++count;
            }
        }
        return count;
    }

    private double computeMatrixOverlap(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int count = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            for (int j = 0; j < trueInteractions[0].length; ++j) {
                if (trueInteractions[i][j] != 1 || trueInteractions[i][j] != predictedInteractions[i][j]) continue;
                ++count;
            }
        }
        return count;
    }

    private int findInnerInteraction(String s, int n) {
        if (s.charAt(n) != '(') {
            return -1;
        }
        for (int i = n + 1; i < s.length(); ++i) {
            if (s.charAt(i) == ')') {
                return i;
            }
            if (s.charAt(i) != '(') continue;
            return -1;
        }
        return -1;
    }

    private IntervalInt findInnerInteraction(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int j = this.findInnerInteraction(s, i);
            if (j < 0) continue;
            return new IntervalInt(i, j);
        }
        return null;
    }

    private int[][] parseBracketInteractions(String structure) {
        int foundInteractions;
        assert (structure != null);
        int len = structure.length();
        int[][] result = new int[len][len];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = structure.charAt(i) == UNKNOWN_INTERACTION_CHAR || structure.charAt(j) == UNKNOWN_INTERACTION_CHAR ? 0 : -1;
            }
        }
        int numInteractions = StringTools.countChar(structure, '(');
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = this.findInnerInteraction(buf.toString());
            if (intervall == null) {
                this.log.info("Could not find inner interactions in: " + structure);
                break;
            }
            int j = intervall.getLower();
            int k = intervall.getUpper();
            this.log.fine("Found interaction");
            this.log.fine("Structure: " + structure);
            this.log.fine("Interaction: " + j + "   " + k);
            result[j][k] = 1;
            result[k][j] = 1;
            buf.setCharAt(j, '.');
            buf.setCharAt(k, '.');
        }
        assert (foundInteractions == numInteractions);
        return result;
    }

    private double scoreStructureSequence(StringBuffer bseq, int[][] interactions) throws IOException, ParsingException {
        assert (interactions.length == bseq.length());
        double score = 0.0;
        String[] rnafoldLines = this.launchRnafold(bseq.toString());
        String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
        int[][] predictedInteractions = this.parseBracketInteractions(bracket);
        double result = this.computeMatrixDifference(interactions, predictedInteractions) / 2.0;
        return result;
    }

    private double scoreStructureSequenceOverlap(StringBuffer bseq, int[][] interactions) throws IOException, ParsingException {
        assert (interactions.length == bseq.length());
        double score = 0.0;
        String[] rnafoldLines = this.launchRnafold(bseq.toString());
        String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
        int[][] predictedInteractions = this.parseBracketInteractions(bracket);
        double result = this.computeMatrixOverlap(interactions, predictedInteractions) / 2.0;
        return result;
    }

    private String generateFusedSequence(String s1, String s2) {
        return s1 + this.linkerSequence + s2;
    }

    private int[][] generateFusedInteractions(int[][] interactionsA, int[][] interactionsB, int[][] interactionsAB, boolean orderFlag) {
        int j;
        int i;
        assert (interactionsA.length == interactionsAB.length);
        assert (interactionsB.length == interactionsAB[0].length);
        if (!orderFlag) {
            return this.generateFusedInteractions(interactionsB, interactionsA, IntegerArrayTools.transpose(interactionsAB), true);
        }
        assert (orderFlag);
        int linkLen = 0;
        int l1 = interactionsA.length;
        int l2 = interactionsB.length;
        int fusedLen = l1 + linkLen + l2;
        assert (fusedLen > 0);
        int[][] result = new int[fusedLen][fusedLen];
        for (i = 0; i < result.length; ++i) {
            for (j = 0; j < result[0].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < interactionsA.length; ++i) {
            for (j = 0; j < interactionsA[0].length; ++j) {
                result[i][j] = interactionsA[i][j];
            }
        }
        for (i = 0; i < interactionsB.length; ++i) {
            for (j = 0; j < interactionsB[0].length; ++j) {
                result[i + l1 + linkLen][j + l1 + linkLen] = interactionsB[i][j];
            }
        }
        for (i = 0; i < interactionsAB.length; ++i) {
            for (j = 0; j < interactionsAB[0].length; ++j) {
                int id1 = i;
                int id2 = j + l1 + linkLen;
                assert (id1 < result.length);
                assert (id2 < result[0].length);
                result[id1][id2] = interactionsAB[i][j];
                result[id2][id1] = interactionsAB[i][j];
            }
        }
        return result;
    }

    private double scoreStructureSequencePair(StringBuffer bseq1, StringBuffer bseq2, int[][][][] interactions, int m, int n, boolean orderFlag) throws IOException, ParsingException {
        assert (interactions[m][n].length == bseq1.length());
        assert (interactions[m][n][0].length == bseq2.length());
        double result = 0.0;
        String fusedSequence = "";
        int[][] fusedInteractions = this.generateFusedInteractions(interactions[m][m], interactions[n][n], interactions[m][n], orderFlag);
        assert (fusedInteractions.length == fusedInteractions[0].length);
        fusedSequence = orderFlag ? this.generateFusedSequence(bseq1.toString(), bseq2.toString()) : this.generateFusedSequence(bseq2.toString(), bseq1.toString());
        if (this.probabilityMode) {
            double[][] probMatrix = this.launchRnacofoldProb(fusedSequence);
            assert (probMatrix.length == interactions[m][m].length + interactions[n][n].length);
            result = this.scoreProbabilityMatrix(probMatrix, fusedInteractions);
        } else {
            String[] rnafoldLines = this.launchRnacofold(fusedSequence);
            String bracket = RnaFoldTools.parseRnacofoldStructure(rnafoldLines);
            int[][] predictedInteractions = this.parseBracketInteractions(bracket);
            result = this.computeMatrixDifference(fusedInteractions, predictedInteractions) / 2.0;
            this.log.info("Matrix difference for comparing fused desired and predicted structure: " + result + " " + bracket);
        }
        return result;
    }

    int[] extractIntegerWeights(SecondaryStructure structure) {
        int[] result = new int[structure.getSequenceCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)structure.getSequence(i).getWeight();
        }
        return result;
    }

    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int[] weights, boolean activeState) {
        double score = 0.0;
        try {
            for (int i = 0; i < bseqs.length; ++i) {
                if (weights[i] == 0) continue;
                int interactionCount = 0;
                for (int j = i + 1; j < bseqs.length; ++j) {
                    if (weights[j] == 0) continue;
                    ++interactionCount;
                    double crossTerm1 = this.scoreStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices, i, j, true);
                    double crossTerm2 = this.scoreStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices, i, j, false);
                    score += 0.5 * (crossTerm1 + crossTerm2);
                    this.log.fine("Cross terms " + (i + 1) + " " + (j + 1) + " : " + crossTerm1 + " " + crossTerm2);
                }
            }
        }
        catch (IOException ioe) {
            this.log.severe("Error launching RNAfold! Error message: " + ioe.getMessage());
            return 0.0;
        }
        catch (ParsingException pe) {
            this.log.severe("Error parsing RNAfold results! Error message: " + pe.getMessage());
            return 0.0;
        }
        return score += this.scoreStructureSequenceOverlap(bseqs[0], interactionMatrices[0][0]);
    }

    StringBuffer generateCombinedNotFirstSeq(StringBuffer[] bseqs, int[] weights) {
        StringBuffer result = new StringBuffer();
        for (int i = 1; i < weights.length; ++i) {
            if (weights[i] == 0) continue;
            if (result.length() > 0) {
                result.append(this.linkerSequence2);
            }
            result.append(bseqs[i].toString());
        }
        return result;
    }

    int getCombinedInteraction(int[][][][] interactionMatrices, int[] weights, int i, int j) {
        int n0 = 0;
        int x = i;
        int y = 0;
        int offset = 0;
        int n1 = 0;
        int linkLen = this.linkerSequence2.length();
        for (int k = 1; k < weights.length; ++k) {
            int currLen = interactionMatrices[0][k][0].length;
            if (weights[k] == 0) continue;
            if (offset + currLen + linkLen < j) {
                offset += currLen + linkLen;
                continue;
            }
            n1 = k;
            y = j - offset;
        }
        assert (x < interactionMatrices[n0][n1].length);
        assert (y < interactionMatrices[n0][n1][x].length);
        return interactionMatrices[n0][n1][x][y];
    }

    int[][] generateCombinedInteractionWithFirstMatrix(StringBuffer[] bseqs, int[][][][] interactionMatrices, int[] weights) {
        int origLen = bseqs[0].length();
        int otherLen = this.generateCombinedNotFirstSeq(bseqs, weights).length();
        int[][] result = new int[origLen][otherLen];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result.length; ++j) {
                result[i][j] = this.getCombinedInteraction(interactionMatrices, weights, i, j);
            }
        }
        return result;
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        assert (false);
        return null;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        int[] refWeights = this.extractIntegerWeights(structure);
        IntegerArrayGenerator gen = new IntegerArrayGenerator(refWeights.length, 2);
        assert (gen.hasNext());
        int[] currWeights = gen.get();
        double result = 0.0;
        do {
            boolean activeState = IntegerArrayTools.equals(currWeights, refWeights);
            result += this.scoreStructure(bseqs, structure, interactionMatrices, currWeights, activeState);
        } while (gen.hasNext() && (currWeights = gen.next()) != null);
        return result;
    }
}

