/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.StringTools;
import generaltools.TestTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import numerictools.IntervalInt;
import org.testng.annotations.Test;
import rnasecondary.InteractionSet;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.RnaInteractionType;
import rnasecondary.SecondaryStructureParser;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleInteractionSet;
import rnasecondary.SimpleMutableSecondaryStructure;
import secondarystructuredesign.PackageConstants;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.Sequence;
import sequence.SimpleMutableSequence;
import sequence.SimpleUnevenAlignment;
import sequence.UnknownSymbolException;

public class PknotsRGParser
implements SecondaryStructureParser {
    public int debugLevel = 0;
    private Logger log = Logger.getLogger("mcsopt");

    public PknotsRGParser() {
        this.log.finest("starting ImprovedSecondaryStructureParser");
    }

    private int findInnerInteraction(String s, int n, char openChar, char closeChar) {
        if (s.charAt(n) != openChar) {
            return -1;
        }
        for (int i = n + 1; i < s.length(); ++i) {
            if (s.charAt(i) == closeChar) {
                return i;
            }
            if (s.charAt(i) != openChar) continue;
            return -1;
        }
        return -1;
    }

    private IntervalInt findInnerInteraction(String s, char openChar, char closeChar) {
        for (int i = 0; i < s.length(); ++i) {
            int j = this.findInnerInteraction(s, i, openChar, closeChar);
            if (j < 0) continue;
            return new IntervalInt(i, j);
        }
        return null;
    }

    int addInteractions(String structure, Sequence seq, InteractionSet interactions, char openChar, char closeChar) {
        int foundInteractions;
        int numInteractions = StringTools.countChar(structure, openChar);
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = this.findInnerInteraction(buf.toString(), openChar, closeChar);
            if (intervall == null) {
                this.log.info("Could not find inner interactions in: " + structure);
                break;
            }
            int j = intervall.getLower();
            int k = intervall.getUpper();
            if (this.debugLevel > 1) {
                System.out.println("Found interaction");
                System.out.println("Structure: " + structure);
                System.out.println("Interaction: " + j + "   " + k);
            }
            interactions.add(new SimpleInteraction(seq.getResidue(j), seq.getResidue(k), new RnaInteractionType(1)));
            buf.setCharAt(j, '.');
            buf.setCharAt(k, '.');
        }
        for (int i = 0; i < structure.length(); ++i) {
            if (structure.charAt(i) != '?') continue;
            this.log.info("Setting residue " + (i + 1) + " to ignore status!");
            seq.getResidue(i).setProperty("seqstatus", "ignore");
        }
        assert (foundInteractions == numInteractions);
        return foundInteractions;
    }

    @Override
    public MutableSecondaryStructure parse(String filename) throws IOException, ParseException {
        FileInputStream fis = new FileInputStream(filename);
        String[] lines = StringTools.readAllLines(fis);
        return this.parse(lines);
    }

    @Override
    public MutableSecondaryStructure parse(String[] lines) throws ParseException {
        try {
            SimpleUnevenAlignment sequences = new SimpleUnevenAlignment();
            SimpleInteractionSet interactions = new SimpleInteractionSet();
            ArrayList<String> structures = new ArrayList<String>();
            String name = null;
            int step = 1;
            double weight = 1.0;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (this.debugLevel > 1) {
                    this.log.info("Parsing line " + (i + 1) + " : " + line);
                }
                if (step == 1) {
                    if (line.startsWith(">")) {
                        if (line.length() < 2) {
                            throw new ParseException("No name specified in line " + line, i + 1);
                        }
                        if (name != null) {
                            throw new ParseException("Name already defined: " + line, i + 1);
                        }
                        name = line.substring(1, line.length());
                        continue;
                    }
                    String seqData = line;
                    ArrayList<Integer> lowCharIndices = new ArrayList<Integer>();
                    for (int ii = 0; ii < seqData.length(); ++ii) {
                        if (!Character.isLowerCase(seqData.charAt(ii))) continue;
                        lowCharIndices.add(ii);
                    }
                    this.log.fine("Using alphabet: " + DnaTools.AMBIGUOUS_RNA_ALPHABET);
                    SimpleMutableSequence sequence = new SimpleMutableSequence(seqData.toUpperCase(), name, DnaTools.AMBIGUOUS_RNA_ALPHABET);
                    if (weight != 1.0) {
                        sequence.setWeight(weight);
                    }
                    for (int ii = 0; ii < lowCharIndices.size(); ++ii) {
                        int idx = (Integer)lowCharIndices.get(ii);
                        sequence.getResidue(idx).setProperty("sequence_status", "fragment");
                    }
                    if (this.debugLevel > 1) {
                        this.log.info("Adding sequence " + ((Object)sequence).toString());
                    }
                    sequences.addSequence(sequence);
                    ++step;
                    continue;
                }
                String[] words = line.split(" ");
                if (words.length > 1) {
                    structures.add(words[0]);
                    if (this.debugLevel <= 1) break;
                    this.log.info("Adding structure " + words[0]);
                    break;
                }
                this.log.info("Expecting structure. Ignoring line : " + line);
            }
            assert (structures.size() == 1);
            String structure = (String)structures.get(0);
            if (this.debugLevel > 0) {
                this.log.info("Adding intra-sequence interactions for structure: " + structure);
            }
            this.addInteractions(structure, sequences.getSequence(0), interactions, '(', ')');
            this.addInteractions(structure, sequences.getSequence(0), interactions, '{', '}');
            this.addInteractions(structure, sequences.getSequence(0), interactions, '[', ']');
            return new SimpleMutableSecondaryStructure(sequences, interactions);
        }
        catch (DuplicateNameException e1) {
            System.out.println("DuplicateNameException: " + e1.getMessage());
        }
        catch (UnknownSymbolException e2) {
            System.out.println("UnknownSymbolException: " + e2.getMessage());
        }
        return null;
    }

    private void parseSequences(String[] lines) {
    }

    private void parseInteractions(String[] lines) {
    }

    @Test(groups={"new", "slow"})
    public void testParse() {
        ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesignTest");
        String fileNames = rb.getString("testPknotsRGSecondaryStructures");
        String[] tokens = fileNames.split(",");
        PknotsRGParser parser = new PknotsRGParser();
        for (int i = 0; i < tokens.length; ++i) {
            MutableSecondaryStructure structure;
            block6: {
                structure = null;
                String fileName = tokens[i];
                if (fileName.length() < 2) continue;
                System.out.println("Reading file: " + fileName);
                try {
                    structure = parser.parse(tokens[i]);
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    assert (false);
                }
                catch (ParseException pe) {
                    System.out.println(pe.getMessage());
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            assert (structure != null);
            SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
            System.out.println("Read secondary structure: " + writer.writeString(structure));
        }
    }

    @Test(groups={"new", "slow"})
    public void testParseDummyPK() {
        MutableSecondaryStructure structure;
        String methodName;
        block6: {
            methodName = "testParseDummyPK";
            System.out.println(TestTools.generateMethodHeader(methodName));
            PknotsRGParser parser = new PknotsRGParser();
            structure = null;
            String fileName = PackageConstants.NANOTILER_HOME + "/test/fixtures/dummypk_pknotsRG.txt";
            System.out.println("Reading file: " + fileName);
            try {
                structure = parser.parse(fileName);
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                assert (false);
            }
            catch (ParseException pe) {
                System.out.println(pe.getMessage());
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (structure != null);
        SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
        System.out.println("Read secondary structure: " + writer.writeString(structure));
        assert (structure.getInteractionCount() == 37);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }
}

