/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import java.util.Properties;
import secondarystructuredesign.CritonScorer;
import secondarystructuredesign.DummyEnergySecondaryStructureScorer;
import secondarystructuredesign.MatchFoldAllSecondaryStructureScorer;
import secondarystructuredesign.MatchFoldProbScorer;
import secondarystructuredesign.MatchFoldSecondaryStructureScorer;
import secondarystructuredesign.MonteCarloSequenceOptimizer;
import secondarystructuredesign.RnacofoldSecondaryStructureScorer;
import secondarystructuredesign.RnacofoldSecondaryStructureScorer2;
import secondarystructuredesign.SequenceOptimizer;
import secondarystructuredesign.SequenceOptimizerFactory;
import secondarystructuredesign.SimpleSecondaryStructurePredictorScorer;

public class MonteCarloSequenceOptimizerVersionsFactory
implements SequenceOptimizerFactory {
    private Properties rb;
    public static final int VERSION_MARCH_30_2009 = 1;
    public static final int VERSION_OCTOBER_2008 = 2;
    public static final int VERSION_APRIL_16_2009 = 3;
    public static final int VERSION_RULES_ONLY_1 = 4;
    public static final int VERSION_JUNE_16_2009 = 5;
    public static final int VERSION_JUNE_16b_2009 = 6;
    public static final int VERSION_JUNE_17_2009 = 7;
    public static final int VERSION_NO_OPTIMIZATION = 8;
    public static final int VERSION_DECEMBER_2010 = 9;
    public static final int VERSION_JANUARY_2011 = 10;
    public static final int VERSION_DEFAULT = 2;

    public MonteCarloSequenceOptimizerVersionsFactory(int _versionId) {
        this.rb = new Properties();
        this.rb.setProperty("version", "" + _versionId);
    }

    public MonteCarloSequenceOptimizerVersionsFactory(Properties _rb) {
        this.rb = (Properties)_rb.clone();
    }

    @Override
    public SequenceOptimizer generate() {
        MonteCarloSequenceOptimizer optimizer = null;
        int versionId = 2;
        if (this.rb.getProperty("version") != null) {
            versionId = Integer.parseInt(this.rb.getProperty("version"));
        }
        switch (versionId) {
            case 2: {
                optimizer = this.generateVersionOctober2008();
                break;
            }
            case 1: {
                optimizer = this.generateVersionMarch302009();
                break;
            }
            case 3: {
                optimizer = this.generateVersionApril162009();
                break;
            }
            case 4: {
                optimizer = this.generateRuleOnlyVersionMay202009();
                break;
            }
            case 5: {
                optimizer = this.generateVersionJune162009();
                break;
            }
            case 6: {
                optimizer = this.generateVersionJune16b2009();
                break;
            }
            case 7: {
                optimizer = this.generateVersionJune172009();
                break;
            }
            case 9: {
                optimizer = this.generateVersionDecember2010();
                break;
            }
            case 10: {
                optimizer = this.generateVersionJanuary2011();
                break;
            }
            case 8: {
                optimizer = this.generateNoOptimizationVersion();
                break;
            }
            default: {
                System.out.println("Internal error: unknown optimizer version");
                assert (false);
                break;
            }
        }
        try {
            this.parseAndSetOptimizer(optimizer, this.rb);
        }
        catch (NumberFormatException nfe) {
            System.out.println(nfe.getMessage());
            System.out.println("Error parsing version in parameter file.");
            System.exit(1);
        }
        return optimizer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAndSetOptimizer(MonteCarloSequenceOptimizer optimizer, Properties rb) throws NumberFormatException {
        String randomizeString;
        if (rb.getProperty("error1") != null) {
            optimizer.setErrorScoreLimit(Double.parseDouble(rb.getProperty("error1")));
        }
        if (rb.getProperty("iter") != null) {
            optimizer.setIterMax(Integer.parseInt(rb.getProperty("iter")));
        }
        if (rb.getProperty("iter2") != null) {
            optimizer.setIter2Max(Integer.parseInt(rb.getProperty("iter2")));
        }
        if (rb.getProperty("rerun") != null) {
            optimizer.setRerun(Integer.parseInt(rb.getProperty("rerun")));
        }
        boolean optimizeFlag = true;
        String optimizeString = rb.getProperty("optimize");
        if (optimizeString != null) {
            if (optimizeString.equals("true")) {
                optimizeFlag = true;
            } else {
                if (!optimizeString.equals("false")) throw new NumberFormatException("Expected true or false for boolean option optimize");
                optimizeFlag = false;
            }
        }
        if ((randomizeString = rb.getProperty("randomize")) != null) {
            if (randomizeString.equals("true")) {
                optimizer.setRandomizeFlag(true);
                return;
            } else {
                if (!randomizeString.equals("false")) throw new NumberFormatException("Expected true or false for boolean option randomize");
                optimizer.setRandomizeFlag(false);
            }
            return;
        } else {
            if (optimizeFlag && (optimizer.getIterMax() != 0 || optimizer.getIter2Max() != 0)) return;
            optimizer.setRandomizeFlag(false);
        }
    }

    private MonteCarloSequenceOptimizer generateVersionMarch302009() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(146.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(1000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        CritonScorer scorer = new CritonScorer();
        scorer.setConsecutiveLimit(3);
        scorer.setConsecutiveLimitG(2);
        scorer.setCritonLen(6);
        scorer.setAuViolationWeight(10.0);
        scorer.setGcViolationWeight(1.0);
        scorer.setBranchMigrationWeight(10.0);
        scorer.setConsecutiveWeight(10.0);
        scorer.setGCMinFracWeight(0.0);
        scorer.setGuComplementMode(false);
        scorer.setZipperWeight(10.0);
        optimizer.setDefaultScorer(scorer);
        MatchFoldSecondaryStructureScorer scorer2 = new MatchFoldSecondaryStructureScorer();
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionJune162009() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(146.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(1000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        CritonScorer scorer = new CritonScorer();
        scorer.setConsecutiveLimit(3);
        scorer.setConsecutiveLimitG(2);
        scorer.setCritonLen(5);
        scorer.setAuViolationWeight(10.0);
        scorer.setGcViolationWeight(1.0);
        scorer.setBranchMigrationWeight(10.0);
        scorer.setConsecutiveWeight(10.0);
        scorer.setGCMinFracWeight(0.0);
        scorer.setGuComplementMode(false);
        scorer.setZipperWeight(10.0);
        optimizer.setDefaultScorer(scorer);
        MatchFoldSecondaryStructureScorer scorer2 = new MatchFoldSecondaryStructureScorer();
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionJune16b2009() {
        System.out.println("Creating MonteCarloSequenceOptimizer version generateVersionJune16b2009");
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(60.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(10000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        CritonScorer scorer = new CritonScorer();
        scorer.setConsecutiveLimit(3);
        scorer.setConsecutiveLimitG(2);
        scorer.setCritonLen(5);
        scorer.setAuViolationWeight(10.0);
        scorer.setGcViolationWeight(1.0);
        scorer.setBranchMigrationWeight(10.0);
        scorer.setConsecutiveWeight(10.0);
        scorer.setGCMinFracWeight(0.0);
        scorer.setGuComplementMode(false);
        scorer.setZipperWeight(10.0);
        optimizer.setDefaultScorer(scorer);
        RnacofoldSecondaryStructureScorer scorer2 = new RnacofoldSecondaryStructureScorer();
        scorer2.setSelfEnergyCutoff(-10.0);
        SimpleSecondaryStructurePredictorScorer scorer3 = new SimpleSecondaryStructurePredictorScorer();
        scorer2.setSubScorer(scorer3);
        scorer2.setSubScorerWeight(5.0);
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionJune172009() {
        System.out.println("Creating MonteCarloSequenceOptimizer version generateVersionJune16b2009");
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(60.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(10000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        CritonScorer scorer = new CritonScorer();
        scorer.setConsecutiveLimit(3);
        scorer.setConsecutiveLimitG(2);
        scorer.setCritonLen(5);
        scorer.setAuViolationWeight(10.0);
        scorer.setGcViolationWeight(1.0);
        scorer.setBranchMigrationWeight(10.0);
        scorer.setConsecutiveWeight(10.0);
        scorer.setGCMinFracWeight(0.0);
        scorer.setGuComplementMode(false);
        scorer.setZipperWeight(10.0);
        optimizer.setDefaultScorer(scorer);
        RnacofoldSecondaryStructureScorer2 scorer2 = new RnacofoldSecondaryStructureScorer2();
        scorer2.setSelfEnergyCutoff(-5.0);
        SimpleSecondaryStructurePredictorScorer scorer3 = new SimpleSecondaryStructurePredictorScorer();
        scorer2.setSubScorer(scorer3);
        scorer2.setSubScorerWeight(5.0);
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionOctober2008() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(60.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(40000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(0.05);
        RnacofoldSecondaryStructureScorer scorer2 = new RnacofoldSecondaryStructureScorer();
        scorer2.setSelfEnergyCutoff(-10.0);
        SimpleSecondaryStructurePredictorScorer scorer3 = new SimpleSecondaryStructurePredictorScorer();
        scorer2.setSubScorer(scorer3);
        scorer2.setSubScorerWeight(5.0);
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionJanuary2011() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(60.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(40000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        MatchFoldProbScorer scorer2 = new MatchFoldProbScorer();
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionApril162009() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(146.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(1000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        CritonScorer scorer = new CritonScorer();
        scorer.setConsecutiveLimit(3);
        scorer.setConsecutiveLimitG(2);
        scorer.setCritonLen(6);
        scorer.setAuViolationWeight(10.0);
        scorer.setGcViolationWeight(1.0);
        scorer.setBranchMigrationWeight(10.0);
        scorer.setConsecutiveWeight(10.0);
        scorer.setGCMinFracWeight(0.0);
        scorer.setGuComplementMode(false);
        scorer.setZipperWeight(10.0);
        optimizer.setDefaultScorer(scorer);
        MatchFoldAllSecondaryStructureScorer scorer2 = new MatchFoldAllSecondaryStructureScorer();
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateRuleOnlyVersionMay202009() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(146.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(1000);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(5);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        CritonScorer scorer = new CritonScorer();
        scorer.setConsecutiveLimit(3);
        scorer.setConsecutiveLimitG(2);
        scorer.setCritonLen(6);
        scorer.setAuViolationWeight(10.0);
        scorer.setGcViolationWeight(1.0);
        scorer.setBranchMigrationWeight(10.0);
        scorer.setConsecutiveWeight(10.0);
        scorer.setGCMinFracWeight(0.0);
        scorer.setGuComplementMode(false);
        scorer.setZipperWeight(10.0);
        optimizer.setDefaultScorer(scorer);
        DummyEnergySecondaryStructureScorer scorer2 = new DummyEnergySecondaryStructureScorer();
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateNoOptimizationVersion() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(100000.0);
        optimizer.setIterMax(1);
        optimizer.setIter2Max(1);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(1);
        optimizer.setRandomizeFlag(true);
        optimizer.setFinalScoreWeight(1.0);
        DummyEnergySecondaryStructureScorer scorer = new DummyEnergySecondaryStructureScorer();
        optimizer.setDefaultScorer(scorer);
        DummyEnergySecondaryStructureScorer scorer2 = new DummyEnergySecondaryStructureScorer();
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }

    private MonteCarloSequenceOptimizer generateVersionDecember2010() {
        MonteCarloSequenceOptimizer optimizer = new MonteCarloSequenceOptimizer();
        optimizer.setErrorScoreLimit(60.0);
        optimizer.setIterMax(20000);
        optimizer.setIter2Max(10);
        optimizer.setKt(1.0);
        optimizer.setKt2(0.4);
        optimizer.setRerun(1);
        optimizer.setRandomizeFlag(true);
        double finalScoreWeight = 0.05;
        optimizer.setFinalScoreWeight(finalScoreWeight);
        RnacofoldSecondaryStructureScorer scorer2 = new RnacofoldSecondaryStructureScorer();
        scorer2.setSelfEnergyCutoff(-10.0);
        ((CritonScorer)optimizer.getDefaultScorer()).setDefaultScorerWeight(5.0 * finalScoreWeight);
        optimizer.setFinalScorer(scorer2);
        return optimizer;
    }
}

