/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureCTFormatWriter;
import secondarystructuredesign.AbstractSecondaryStructureScorer;

public class MatchFoldProbScorer
extends AbstractSecondaryStructureScorer {
    private double scale = 1.0;
    private Level debugLevel = Level.INFO;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static String scriptName = "matchfoldprob.pl";
    private boolean debugMode = false;

    private String[] launchFolding(StringBuffer[] sequences, SecondaryStructure structure) throws IOException {
        File tmpDir = new File(".");
        File tmpInputFile = File.createTempFile("nanotiler_matchfold", ".seq", tmpDir);
        if (!this.debugMode) {
            tmpInputFile.deleteOnExit();
        }
        String inputFileName = tmpInputFile.getAbsolutePath();
        if (this.debugLevel == Level.FINE) {
            log.info("temp file for MatchFold results: " + inputFileName);
        }
        FileWriter bf = new FileWriter(inputFileName);
        if (this.debugMode) {
            System.out.println("Writing to file: " + inputFileName);
        }
        SecondaryStructureCTFormatWriter writer = new SecondaryStructureCTFormatWriter();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < sequences.length; ++i) {
            buf.append(sequences[i]);
        }
        bf.write(writer.writeString(buf.toString(), structure));
        bf.close();
        File tmpOutputFile = File.createTempFile("nanotiler_matchfold", "_prob.dat", tmpDir);
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        if (!this.debugMode) {
            tmpOutputFile.deleteOnExit();
        }
        String[] commandWords = new String[]{scriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        if (this.debugLevel.equals(Level.FINE)) {
            log.info("Issuing command: " + scriptName + " " + inputFileName + " " + outputFileName);
        }
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        String[] resultLines = null;
        FileInputStream resultFile = null;
        try {
            resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            log.warning("Error when scraping result file from: " + outputFileName + " : " + ioe.getMessage());
            assert (false);
            throw ioe;
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
                if (!this.debugMode) {
                    File file = new File(outputFileName);
                    file.delete();
                }
            }
            if (!this.debugMode && tmpInputFile != null) {
                tmpInputFile.delete();
            }
        }
        if (resultLines == null) {
            assert (false);
            log.warning("matchfold results were null!");
        }
        return resultLines;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        double result = 1.0;
        int numResidues = structure.getSequences().getTotalResidueCount();
        assert (numResidues > 0);
        try {
            String[] resultLines = this.launchFolding(bseqs, structure);
            if (resultLines.length > 0) {
                String lastLine = resultLines[resultLines.length - 1];
                String[] words = lastLine.split(" ");
                if (words.length >= 2 && words[0].equals("Score:")) {
                    result = Double.parseDouble(words[1]);
                    if (this.debugMode) {
                        System.out.println("MatchFold probability matrix score: " + result);
                    }
                } else {
                    log.warning("Error parsing matchfold results: " + resultLines.length + " : " + lastLine);
                    for (int i = 0; i < resultLines.length; ++i) {
                        System.out.println(resultLines[i]);
                    }
                }
            }
        }
        catch (IOException ioe) {
            log.warning("Error obtaining results from matchfold script: " + ioe.getMessage());
        }
        catch (NumberFormatException nfe) {
            log.warning("Error parsing matchfold score: " + nfe.getMessage());
        }
        assert (result >= 0.0);
        return result;
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        Properties resultProperties = new Properties();
        double result = this.scoreStructure(bseqs, structure, interactionMatrices);
        resultProperties.setProperty("score", "" + result);
        assert (result >= 0.0);
        return resultProperties;
    }
}

